<?php

namespace App\Http\Controllers\Payment;

use App\Http\Controllers\Controller;
use App\Services\Payment\StripeService;
use App\Services\Payment\PayPalService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class WebhookController extends Controller
{
    /**
     * Handle Stripe webhook
     */
    public function stripe(Request $request)
    {
        $payload = $request->getContent();
        $signature = $request->header('Stripe-Signature');

        try {
            $stripeService = new StripeService();
            $result = $stripeService->handleWebhook($payload, $signature);

            if ($result['success']) {
                return response()->json(['status' => 'success'], 200);
            } else {
                Log::error('Stripe webhook failed', ['error' => $result['error']]);
                return response()->json(['error' => $result['error']], 400);
            }
        } catch (\Exception $e) {
            Log::error('Stripe webhook exception', ['message' => $e->getMessage()]);
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    /**
     * Handle PayPal webhook
     */
    public function paypal(Request $request)
    {
        try {
            $paypalService = new PayPalService();
            $result = $paypalService->handleWebhook($request->all(), $request->headers->all());

            if ($result['success']) {
                return response()->json(['status' => 'success'], 200);
            } else {
                Log::error('PayPal webhook failed', ['error' => $result['error']]);
                return response()->json(['error' => $result['error']], 400);
            }
        } catch (\Exception $e) {
            Log::error('PayPal webhook exception', ['message' => $e->getMessage()]);
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
