<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

use App\Models\Business;
use App\Models\BusinessStaff;

class TeamInvitation extends Mailable
{
    use Queueable, SerializesModels;

    public $business;
    public $staff;

    /**
     * Create a new message instance.
     */
    public function __construct(Business $business, BusinessStaff $staff)
    {
        $this->business = $business;
        $this->staff = $staff;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this
            ->subject('You have been invited to join a team')
            ->markdown('emails.team.invitation')
            ->with([
                'invitation' => $this->staff,
                'business'   => $this->business,
            ]);
    }
}
