<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Follow extends Model
{
    use HasFactory;

    protected $fillable = [
        'follower_id',
        'following_id',
    ];

    /**
     * User who is following
     */
    public function follower()
    {
        return $this->belongsTo(User::class, 'follower_id');
    }

    /**
     * User being followed
     */
    public function following()
    {
        return $this->belongsTo(User::class, 'following_id');
    }

    /**
     * Scope to get follows for a specific user
     */
    public function scopeForUser($query, $userId)
    {
        return $query->where('follower_id', $userId);
    }

    /**
     * Scope to get followers of a specific user
     */
    public function scopeFollowersOf($query, $userId)
    {
        return $query->where('following_id', $userId);
    }
}
