<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MarketingPackage extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'name_ar',
        'description',
        'description_ar',
        'price',
        'currency',
        'duration_days',
        'impressions_limit',
        'clicks_limit',
        'features',
        'is_active',
        'order',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'features' => 'array',
        'is_active' => 'boolean',
    ];

    /**
     * Marketing campaigns using this package
     */
    public function campaigns()
    {
        return $this->hasMany(MarketingCampaign::class, 'package_id');
    }

    /**
     * Active packages
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Order by position
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('order');
    }
}
