<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Referral extends Model
{
    use HasFactory;

    protected $fillable = [
        'referrer_business_id',
        'referred_business_id',
        'referral_code',
        'status',
        'commission_rate',
        'commission_amount',
        'completed_at',
    ];

    protected $casts = [
        'commission_rate' => 'decimal:2',
        'commission_amount' => 'decimal:2',
        'completed_at' => 'datetime',
    ];

    public function referrerBusiness()
    {
        return $this->belongsTo(Business::class, 'referrer_business_id');
    }

    public function referredBusiness()
    {
        return $this->belongsTo(Business::class, 'referred_business_id');
    }
}
