<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SpotlightComment extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'spotlight_id',
        'user_id',
        'parent_id',
        'comment',
        'status',
    ];

    public function spotlight()
    {
        return $this->belongsTo(Spotlight::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function parent()
    {
        return $this->belongsTo(SpotlightComment::class, 'parent_id');
    }

    public function replies()
    {
        return $this->hasMany(SpotlightComment::class, 'parent_id');
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}
