<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubscriptionPlan extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'name_ar',
        'description',
        'description_ar',
        'type',
        'duration',
        'price',
        'currency',
        'features',
        'max_venues',
        'max_offers',
        'max_staff',
        'is_popular',
        'is_active',
        'is_private',
        'order',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'features' => 'array',
        'is_popular' => 'boolean',
        'is_active' => 'boolean',
        'is_private' => 'boolean',
    ];

    public function subscriptions()
    {
        return $this->hasMany(Subscription::class);
    }

    public function activeSubscriptions()
    {
        return $this->hasMany(Subscription::class)->where('status', 'active');
    }

    public function businesses()
    {
        return $this->hasMany(Business::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeForUsers($query)
    {
        return $query->where('type', 'user');
    }

    public function scopeForBusinesses($query)
    {
        return $query->where('type', 'business');
    }

    public function scopePopular($query)
    {
        return $query->where('is_popular', true);
    }

    public function getDurationInDays()
    {
        return match($this->duration) {
            'monthly' => 30,
            'quarterly' => 90,
            'yearly' => 365,
            default => 30,
        };
    }
}
