<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('offers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('business_id')->constrained()->onDelete('cascade');
            $table->foreignId('venue_id')->nullable()->constrained()->onDelete('cascade');
            $table->foreignId('category_id')->nullable()->constrained()->onDelete('set null');
            $table->string('title');
            $table->string('title_ar')->nullable();
            $table->string('slug')->unique();
            $table->text('description');
            $table->text('description_ar')->nullable();
            $table->enum('offer_type', ['exclusive', 'special', 'regular'])->default('regular');
            $table->enum('discount_type', ['percentage', 'fixed', 'bogo', 'free'])->default('percentage');
            $table->decimal('discount_value', 10, 2)->nullable();
            $table->decimal('original_price', 10, 2)->nullable();
            $table->decimal('discounted_price', 10, 2)->nullable();
            $table->text('terms_conditions')->nullable();
            $table->text('terms_conditions_ar')->nullable();
            $table->json('images')->nullable();
            $table->string('featured_image')->nullable();
            $table->date('start_date');
            $table->date('end_date');
            $table->integer('redemption_limit')->nullable();
            $table->integer('redemption_per_user')->default(1);
            $table->integer('redemption_count')->default(0);
            $table->integer('view_count')->default(0);
            $table->enum('status', ['draft', 'pending_approval', 'approved', 'active', 'expired', 'rejected'])->default('draft');
            $table->enum('approval_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->foreignId('approved_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('approved_at')->nullable();
            $table->text('rejection_reason')->nullable();
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_boosted')->default(false);
            $table->date('boost_end_date')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index('slug');
            $table->index(['business_id', 'status']);
            $table->index(['venue_id', 'status']);
            $table->index(['offer_type', 'status']);
            $table->index(['start_date', 'end_date']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('offers');
    }
};
