<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->command->info('🌱 Starting database seeding...');
        $this->command->newLine();

        // System configuration first
        $this->command->info('📋 Seeding system configurations...');
        $this->call(SystemConfigurationSeeder::class);
        $this->command->newLine();

        // Categories
        $this->command->info('🏷️  Seeding categories...');
        $this->call(CategorySeeder::class);
        $this->command->newLine();

        // Roles and permissions
        $this->command->info('🔐 Seeding roles and permissions...');
        $this->call(RolePermissionSeeder::class);

        // Subscription plans
        $this->command->info('💳 Seeding subscription plans...');
        $this->call(SubscriptionPlanSeeder::class);
        $this->command->info('💳 Seeding user subscription plans...');
        $this->call(UserSubscriptionPlanSeeder::class);
        $this->command->newLine();

        // Marketing packages
        $this->command->info('📢 Seeding marketing packages...');
        $this->call(MarketingPackageSeeder::class);
        $this->command->newLine();

        // Notification templates
        $this->command->info('📬 Seeding notification templates...');
        $this->call(NotificationTemplateSeeder::class);
        $this->command->newLine();

        // FAQs
        $this->command->info('❓ Seeding FAQs...');
        $this->call(FaqSeeder::class);
        $this->command->newLine();

        // Users (test accounts)
        $this->command->info('👤 Seeding users...');
        $this->call(UserSeeder::class);
        $this->command->newLine();

        $this->command->info('✅ Database seeding completed successfully!');
        $this->command->newLine();

        // Summary
        $this->command->info('📊 Seeding Summary:');
        $this->command->table(
            ['Item', 'Status'],
            [
                ['System Configurations', '✅ Complete'],
                ['Categories', '✅ Complete'],
                ['Roles & Permissions', '✅ Complete'],
                ['Subscription Plans', '✅ Complete'],
                ['Marketing Packages', '✅ Complete'],
                ['Notification Templates', '✅ Complete'],
                ['FAQs', '✅ Complete'],
                ['Users (Test Accounts)', '✅ Complete'],
            ]
        );

        $this->command->newLine();
        $this->command->info('🎉 Your Privasee platform is ready to use!');
    }
}
