<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SubscriptionPlan;

class SubscriptionPlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Starter',
                'name_ar' => 'المبتدئ',
                'description' => 'Perfect for small businesses just getting started',
                'description_ar' => 'مثالي للشركات الصغيرة التي بدأت للتو',
                'price' => 299.00,
                'duration_days' => 30,
                'duration_type' => 'monthly',
                'features' => json_encode([
                    'Up to 2 venue locations',
                    'Up to 10 active offers',
                    'Basic analytics',
                    'Email support',
                    'Mobile app access',
                ]),
                'max_venues' => 2,
                'max_offers' => 10,
                'max_staff' => 2,
                'max_photos_per_venue' => 10,
                'analytics_access' => true,
                'priority_support' => false,
                'featured_listing' => false,
                'custom_branding' => false,
                'api_access' => false,
                'sort_order' => 1,
                'is_active' => true,
                'is_popular' => false,
            ],
            [
                'name' => 'Professional',
                'name_ar' => 'المحترف',
                'description' => 'Ideal for growing businesses with multiple locations',
                'description_ar' => 'مثالي للشركات المتنامية مع عدة مواقع',
                'price' => 599.00,
                'duration_days' => 30,
                'duration_type' => 'monthly',
                'features' => json_encode([
                    'Up to 5 venue locations',
                    'Up to 30 active offers',
                    'Advanced analytics & reports',
                    'Priority email support',
                    'Featured in category listings',
                    'Social media integration',
                    'Custom offer scheduling',
                ]),
                'max_venues' => 5,
                'max_offers' => 30,
                'max_staff' => 5,
                'max_photos_per_venue' => 20,
                'analytics_access' => true,
                'priority_support' => true,
                'featured_listing' => true,
                'custom_branding' => false,
                'api_access' => false,
                'sort_order' => 2,
                'is_active' => true,
                'is_popular' => true,
            ],
            [
                'name' => 'Enterprise',
                'name_ar' => 'المؤسسة',
                'description' => 'Complete solution for large businesses and chains',
                'description_ar' => 'حل كامل للشركات الكبيرة والسلاسل',
                'price' => 1299.00,
                'duration_days' => 30,
                'duration_type' => 'monthly',
                'features' => json_encode([
                    'Unlimited venues',
                    'Unlimited offers',
                    'Full analytics suite',
                    'Dedicated account manager',
                    'Premium featured placement',
                    'Custom branding options',
                    'API access for integrations',
                    'White-label solutions',
                    'Priority customer support',
                    'Custom reporting',
                ]),
                'max_venues' => null,
                'max_offers' => null,
                'max_staff' => null,
                'max_photos_per_venue' => 50,
                'analytics_access' => true,
                'priority_support' => true,
                'featured_listing' => true,
                'custom_branding' => true,
                'api_access' => true,
                'sort_order' => 3,
                'is_active' => true,
                'is_popular' => false,
            ],
            [
                'name' => 'Annual Starter',
                'name_ar' => 'المبتدئ السنوي',
                'description' => 'Starter plan with 2 months free',
                'description_ar' => 'خطة المبتدئ مع شهرين مجانا',
                'price' => 2990.00,
                'duration_days' => 365,
                'duration_type' => 'yearly',
                'features' => json_encode([
                    'Up to 2 venue locations',
                    'Up to 10 active offers',
                    'Basic analytics',
                    'Email support',
                    'Mobile app access',
                    '2 months free (save 17%)',
                ]),
                'max_venues' => 2,
                'max_offers' => 10,
                'max_staff' => 2,
                'max_photos_per_venue' => 10,
                'analytics_access' => true,
                'priority_support' => false,
                'featured_listing' => false,
                'custom_branding' => false,
                'api_access' => false,
                'sort_order' => 4,
                'is_active' => true,
                'is_popular' => false,
            ],
            [
                'name' => 'Annual Professional',
                'name_ar' => 'المحترف السنوي',
                'description' => 'Professional plan with 2 months free',
                'description_ar' => 'خطة المحترف مع شهرين مجانا',
                'price' => 5990.00,
                'duration_days' => 365,
                'duration_type' => 'yearly',
                'features' => json_encode([
                    'Up to 5 venue locations',
                    'Up to 30 active offers',
                    'Advanced analytics & reports',
                    'Priority email support',
                    'Featured in category listings',
                    'Social media integration',
                    'Custom offer scheduling',
                    '2 months free (save 17%)',
                ]),
                'max_venues' => 5,
                'max_offers' => 30,
                'max_staff' => 5,
                'max_photos_per_venue' => 20,
                'analytics_access' => true,
                'priority_support' => true,
                'featured_listing' => true,
                'custom_branding' => false,
                'api_access' => false,
                'sort_order' => 5,
                'is_active' => true,
                'is_popular' => false,
            ],
        ];

        foreach ($plans as $plan) {
            SubscriptionPlan::create($plan);
        }

        $this->command->info('Subscription plans seeded successfully!');
    }
}
