<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Role;
use App\Models\NotificationPreference;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = [
            [
                'first_name' => 'Super',
                'last_name' => 'Admin',
                'email' => 'admin@privasee.com',
                'phone' => '+971501234567',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
                'phone_verified_at' => now(),
                'role' => 'super_admin',
                'status' => 'active',
            ],
            [
                'first_name' => 'Admin',
                'last_name' => 'User',
                'email' => 'admin.user@privasee.com',
                'phone' => '+971501234568',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
                'phone_verified_at' => now(),
                'role' => 'admin',
                'status' => 'active',
            ],
            [
                'first_name' => 'Test',
                'last_name' => 'User',
                'email' => 'user@privasee.com',
                'phone' => '+971501234569',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
                'phone_verified_at' => now(),
                'role' => 'user',
                'status' => 'active',
            ],
            [
                'first_name' => 'Business',
                'last_name' => 'Owner',
                'email' => 'business@privasee.com',
                'phone' => '+971501234570',
                'password' => Hash::make('password'),
                'email_verified_at' => now(),
                'phone_verified_at' => now(),
                'role' => 'business_owner',
                'status' => 'active',
            ],
        ];

        foreach ($users as $userData) {
            $roleName = $userData['role'];
            unset($userData['role']);

            $user = User::create($userData);

            // Assign role
            $role = Role::where('name', $roleName)->first();
            if ($role) {
                $user->roles()->attach($role);
            }

            // Create default notification preferences
            NotificationPreference::create([
                'user_id' => $user->id,
                'email_enabled' => true,
                'sms_enabled' => false,
                'push_enabled' => true,
                'account_notifications' => true,
                'offer_new_notifications' => true,
                'offer_update_notifications' => true,
                'offer_exclusive_notifications' => true,
                'redemption_notifications' => true,
                'subscription_notifications' => true,
                'spotlight_notifications' => true,
                'system_notifications' => true,
                'marketing_notifications' => false,
            ]);
        }

        $this->command->info('Users seeded successfully!');
        $this->command->info('Total users created: ' . count($users));
        $this->command->newLine();

        $this->command->info('👤 Test Accounts Created:');
        $this->command->table(
            ['Role', 'Email', 'Password'],
            [
                ['Super Admin', 'admin@privasee.com', 'password'],
                ['Admin', 'admin.user@privasee.com', 'password'],
                ['User', 'user@privasee.com', 'password'],
                ['Business Owner', 'business@privasee.com', 'password'],
            ]
        );
    }
}
