<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SubscriptionPlan;

class UserSubscriptionPlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Free',
                'name_ar' => 'مجاني',
                'description' => 'Basic access to regular offers and platform features',
                'description_ar' => 'وصول أساسي إلى العروض العادية وميزات المنصة',
                'type' => 'user',
                'duration_days' => 30,
                'duration_type' => 'monthly',
                'price' => 0.00,
                'currency' => 'AED',
                'features' => json_encode([
                    'Access to regular offers',
                    'Basic search and filtering',
                    'Save favorite venues',
                    'Leave reviews',
                    'Post in spotlight feed'
                ]),
                'is_popular' => false,
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Premium',
                'name_ar' => 'بريميوم',
                'description' => 'Enhanced access with special offers and premium benefits',
                'description_ar' => 'وصول محسن مع عروض خاصة ومزايا مميزة',
                'type' => 'user',
                'duration_days' => 30,
                'duration_type' => 'monthly',
                'price' => 29.99,
                'currency' => 'AED',
                'features' => json_encode([
                    'All Free features',
                    'Access to special offers',
                    'Priority customer support',
                    'No advertisements',
                    'Advanced search filters',
                    'Offer notifications',
                    'Monthly exclusive deals'
                ]),
                'is_popular' => true,
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'VIP',
                'name_ar' => 'في آي بي',
                'description' => 'Ultimate access with exclusive VIP-only offers and concierge service',
                'description_ar' => 'وصول نهائي مع عروض حصرية لكبار الشخصيات وخدمة الكونسيرج',
                'type' => 'user',
                'duration_type' => 'monthly',
                'duration_days' => 30,
                'price' => 99.99,
                'currency' => 'AED',
                'features' => json_encode([
                    'All Premium features',
                    'Access to exclusive VIP offers',
                    'Early access to new offers',
                    'Concierge service',
                    'VIP-only events',
                    'Personal account manager',
                    'Unlimited redemptions',
                    'Premium venue access',
                    'Birthday special offers'
                ]),
                'is_popular' => false,
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'Premium Annual',
                'name_ar' => 'بريميوم سنوي',
                'description' => 'Premium membership with annual billing (Save 20%)',
                'description_ar' => 'عضوية بريميوم مع الفوترة السنوية (وفر 20٪)',
                'type' => 'user',
                'duration_type' => 'yearly',
                'duration_days' => 365,
                'price' => 287.88, // 29.99 * 12 * 0.8 = 20% discount
                'currency' => 'AED',
                'features' => json_encode([
                    'All Premium features',
                    'Save 20% with annual billing',
                    'Access to special offers',
                    'Priority customer support',
                    'No advertisements',
                    'Advanced search filters',
                    'Offer notifications',
                    'Monthly exclusive deals'
                ]),
                'is_popular' => false,
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'VIP Annual',
                'name_ar' => 'في آي بي سنوي',
                'description' => 'VIP membership with annual billing (Save 25%)',
                'description_ar' => 'عضوية في آي بي مع الفوترة السنوية (وفر 25٪)',
                'type' => 'user',
                'duration_type' => 'yearly',
                'duration_days' => 365,
                'price' => 899.91, // 99.99 * 12 * 0.75 = 25% discount
                'currency' => 'AED',
                'features' => json_encode([
                    'All VIP features',
                    'Save 25% with annual billing',
                    'Access to exclusive VIP offers',
                    'Early access to new offers',
                    'Concierge service',
                    'VIP-only events',
                    'Personal account manager',
                    'Unlimited redemptions',
                    'Premium venue access',
                    'Birthday special offers'
                ]),
                'is_popular' => false,
                'is_active' => true,
                'sort_order' => 5,
            ],
        ];

        foreach ($plans as $plan) {
            SubscriptionPlan::create($plan);
        }

        $this->command->info('User subscription plans seeded successfully!');
        $this->command->info('Total user plans created: ' . count($plans));
    }
}
