@extends('layouts.admin')

@section('title', 'Audit Logs')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Audit Logs</h2>
        <p class="text-muted mb-0">Track all system activities and changes</p>
    </div>
    <div class="d-flex gap-2">
        <button class="btn btn-outline-primary" onclick="exportLogs()">
            <i class="bi bi-download me-2"></i>Export
        </button>
    </div>
</div>

<!-- Filters -->
<div class="admin-card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.audit-logs.index') }}" class="row g-3">
            <div class="col-md-3">
                <input type="text" name="search" class="form-control" placeholder="Search logs..." value="{{ request('search') }}">
            </div>
            <div class="col-md-2">
                <select name="action" class="form-select">
                    <option value="">All Actions</option>
                    <option value="created" {{ request('action') == 'created' ? 'selected' : '' }}>Created</option>
                    <option value="updated" {{ request('action') == 'updated' ? 'selected' : '' }}>Updated</option>
                    <option value="deleted" {{ request('action') == 'deleted' ? 'selected' : '' }}>Deleted</option>
                </select>
            </div>
            <div class="col-md-2">
                <select name="model" class="form-select">
                    <option value="">All Models</option>
                    <option value="User" {{ request('model') == 'User' ? 'selected' : '' }}>User</option>
                    <option value="Business" {{ request('model') == 'Business' ? 'selected' : '' }}>Business</option>
                    <option value="Offer" {{ request('model') == 'Offer' ? 'selected' : '' }}>Offer</option>
                    <option value="Venue" {{ request('model') == 'Venue' ? 'selected' : '' }}>Venue</option>
                </select>
            </div>
            <div class="col-md-3">
                <input type="date" name="date" class="form-control" value="{{ request('date') }}">
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Audit Logs Table -->
<div class="admin-card">
    <div class="admin-card-header">
        <h5 class="mb-0 fw-bold">Audit Logs ({{ $logs->total() ?? 0 }})</h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                <tr>
                    <th>Time</th>
                    <th>User</th>
                    <th>Action</th>
                    <th>Model</th>
                    <th>Description</th>
                    <th>IP Address</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                @forelse($logs as $log)
                <tr>
                    <td>{{ $log->created_at->format('M d, Y H:i') }}</td>
                    <td>{{ $log->user->full_name ?? 'System' }}</td>
                    <td>
                            <span class="badge bg-{{ $log->action === 'created' ? 'success' : ($log->action === 'deleted' ? 'danger' : 'primary') }}">
                                {{ ucfirst($log->action) }}
                            </span>
                    </td>
                    <td>{{ $log->auditable_type }}</td>
                    <td>{{ Str::limit($log->description ?? '', 50) }}</td>
                    <td><code>{{ $log->ip_address }}</code></td>
                    <td>
                        <a href="{{ route('admin.audit-logs.show', $log->id) }}" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-eye"></i>
                        </a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center text-muted py-4">
                        <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                        No audit logs found
                    </td>
                </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if(isset($logs) && $logs->hasPages())
    <div class="admin-card-footer">
        {{ $logs->links() }}
    </div>
    @endif
</div>
@endsection

@push('scripts')
<script>
    function exportLogs() {
        window.location.href = '{{ route("admin.audit-logs.export") }}';
    }
</script>
@endpush
