@extends('layouts.admin')

@section('title', 'Business Management')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Business Management</h2>
        <p class="text-muted mb-0">Review, verify, and manage businesses on the platform</p>
    </div>
</div>

<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Total Businesses</div>
            <div class="stat-value" style="font-size: 28px;">{{ number_format($stats['total'] ?? 487) }}</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Verified</div>
            <div class="stat-value" style="font-size: 28px; color: var(--admin-secondary);">{{ number_format($stats['verified'] ?? 398) }}</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Pending Verification</div>
            <div class="stat-value" style="font-size: 28px; color: var(--admin-warning);">{{ number_format($stats['pending'] ?? 67) }}</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-label">Suspended</div>
            <div class="stat-value" style="font-size: 28px; color: var(--admin-danger);">{{ number_format($stats['suspended'] ?? 10) }}</div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="admin-card mb-4">
    <div class="admin-card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <input type="text" class="form-control" name="search" placeholder="Search by business name, owner, license..."
                       value="{{ request('search') }}">
            </div>
            <div class="col-md-2">
                <select class="form-select" name="status">
                    <option value="">All Status</option>
                    <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                    <option value="verified" {{ request('status') === 'verified' ? 'selected' : '' }}>Verified</option>
                    <option value="rejected" {{ request('status') === 'rejected' ? 'selected' : '' }}>Rejected</option>
                    <option value="suspended" {{ request('status') === 'suspended' ? 'selected' : '' }}>Suspended</option>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select" name="subscription">
                    <option value="">All Subscriptions</option>
                    <option value="free">Free</option>
                    <option value="basic">Basic</option>
                    <option value="premium">Premium</option>
                    <option value="enterprise">Enterprise</option>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select" name="sort">
                    <option value="newest">Newest First</option>
                    <option value="oldest">Oldest First</option>
                    <option value="name_asc">Name A-Z</option>
                    <option value="rating_desc">Highest Rating</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Businesses Table -->
<div class="admin-card">
    <div class="admin-card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0 fw-bold">All Businesses ({{ $businesses->total() }})</h5>
        <button class="btn btn-sm btn-outline-primary" onclick="exportBusinesses()">
            <i class="bi bi-download me-1"></i>Export
        </button>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th>Business</th>
                        <th>Owner</th>
                        <th>License</th>
                        <th>Subscription</th>
                        <th>Rating</th>
                        <th>Joined</th>
                        <th>Status</th>
                        <th style="width: 150px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($businesses as $business)
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="{{ $business->logo ?? 'https://ui-avatars.com/api/?name='.$business->business_name }}"
                                     class="rounded me-2" width="40" height="40" style="object-fit: cover;">
                                <div>
                                    <div class="fw-semibold">{{ $business->business_name }}</div>
                                    <small class="text-muted">{{ $business->total_venues }} venues</small>
                                </div>
                            </div>
                        </td>
                        <td>{{ $business->owner->full_name ?? 'N/A' }}</td>
                        <td>
                            <span class="font-monospace small">{{ $business->trade_license_number }}</span>
                        </td>
                        <td>
                            @if($business->subscription_status === 'active')
                                <span class="badge bg-success">{{ ucfirst($business->subscriptionPlan->name ?? 'Free') }}</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <i class="bi bi-star-fill text-warning me-1"></i>
                                <span class="fw-semibold">{{ number_format($business->rating, 1) }}</span>
                                <small class="text-muted ms-1">({{ $business->total_reviews }})</small>
                            </div>
                        </td>
                        <td>{{ $business->created_at->format('M d, Y') }}</td>
                        <td>
                            @if($business->status === 'verified')
                                <span class="badge bg-success">
                                    <i class="bi bi-check-circle me-1"></i>Verified
                                </span>
                            @elseif($business->status === 'pending')
                                <span class="badge bg-warning">
                                    <i class="bi bi-clock me-1"></i>Pending
                                </span>
                            @elseif($business->status === 'rejected')
                                <span class="badge bg-danger">
                                    <i class="bi bi-x-circle me-1"></i>Rejected
                                </span>
                            @else
                                <span class="badge bg-dark">
                                    <i class="bi bi-ban me-1"></i>Suspended
                                </span>
                            @endif
                        </td>
                        <td>
                            <div class="table-actions">
                                <button class="btn btn-icon btn-outline-primary" onclick="viewBusiness({{ $business->id }})">
                                    <i class="bi bi-eye"></i>
                                </button>
                                @if($business->status === 'pending')
                                    <button class="btn btn-icon btn-outline-success" onclick="verifyBusiness({{ $business->id }})">
                                        <i class="bi bi-check-lg"></i>
                                    </button>
                                @endif
                                <button class="btn btn-icon btn-outline-danger" onclick="suspendBusiness({{ $business->id }})">
                                    <i class="bi bi-ban"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-5">
                            <i class="bi bi-building fs-1 text-muted d-block mb-3"></i>
                            <h5>No businesses found</h5>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if($businesses->hasPages())
    <div class="card-footer bg-white">
        {{ $businesses->links() }}
    </div>
    @endif
</div>
@endsection

@push('scripts')
<script>
function viewBusiness(id) {
    window.location.href = `/admin/businesses/${id}`;
}

function verifyBusiness(id) {
    window.location.href = `/admin/businesses/${id}/verify`;
}

function suspendBusiness(id) {
    if (confirm('Are you sure you want to suspend this business?')) {
        fetch(`/admin/businesses/${id}/suspend`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || 'Failed to suspend business');
            }
        });
    }
}

function exportBusinesses() {
    window.location.href = '/admin/businesses/export';
}
</script>
@endpush
