@extends('layouts.admin')

@section('title', 'Business Details - ' . $business->business_name)

@section('content')
    <div class="admin-header mb-4">
        <div>
            <h2>{{ $business->business_name }}</h2>
            <p class="text-muted mb-0">
                Owner: {{ $business->owner->full_name }} | {{ $business->email }}
            </p>
        </div>
        <div class="d-flex gap-2">
            @if($business->status === 'pending')
                <button class="btn btn-success" onclick="approveBusiness({{ $business->id }})">
                    <i class="bi bi-check-circle me-2"></i>Approve
                </button>
                <button class="btn btn-danger" onclick="rejectBusiness({{ $business->id }})">
                    <i class="bi bi-x-circle me-2"></i>Reject
                </button>
            @endif
            <a href="{{ route('admin.businesses.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back
            </a>
        </div>
    </div>

    <!-- Status & Stats -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Status</div>
                    @if($business->status === 'verified')
                        <span class="badge bg-success px-3 py-2">
                        <i class="bi bi-patch-check me-1"></i>Verified
                    </span>
                    @elseif($business->status === 'pending')
                        <span class="badge bg-warning px-3 py-2">
                        <i class="bi bi-clock me-1"></i>Pending
                    </span>
                    @elseif($business->status === 'rejected')
                        <span class="badge bg-danger px-3 py-2">
                        <i class="bi bi-x-circle me-1"></i>Rejected
                    </span>
                    @else
                        <span class="badge bg-secondary px-3 py-2">{{ ucfirst($business->status) }}</span>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Total Venues</div>
                    <div class="fs-4 fw-bold text-primary">{{ $business->venues()->count() }}</div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Total Offers</div>
                    <div class="fs-4 fw-bold text-success">{{ $business->offers()->count() }}</div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="text-muted small mb-2">Rating</div>
                    <div class="fs-4 fw-bold text-warning">
                        @if($business->rating)
                            {{ number_format($business->rating, 1) }} <i class="bi bi-star-fill"></i>
                        @else
                            No ratings yet
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-lg-8">
            <!-- Business Information -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Business Information</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="text-muted small">Business Name</label>
                            <div class="fw-semibold">{{ $business->business_name }}</div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Business Type</label>
                            <div class="fw-semibold">{{ ucfirst($business->business_type ?? 'N/A') }}</div>
                        </div>

                        <div class="col-12">
                            <label class="text-muted small">Description</label>
                            <div>{{ $business->description ?? 'No description provided' }}</div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">License Number</label>
                            <div class="fw-semibold">{{ $business->license_number ?? 'N/A' }}</div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Tax ID</label>
                            <div class="fw-semibold">{{ $business->tax_id ?? 'N/A' }}</div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Phone</label>
                            <div>{{ $business->phone }}</div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Email</label>
                            <div>{{ $business->email }}</div>
                        </div>

                        @if($business->website)
                            <div class="col-12">
                                <label class="text-muted small">Website</label>
                                <div><a href="{{ $business->website }}" target="_blank">{{ $business->website }}</a></div>
                            </div>
                        @endif

                        <div class="col-12">
                            <label class="text-muted small">Address</label>
                            <div>{{ $business->address }}</div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Registered On</label>
                            <div>{{ $business->created_at->format('M d, Y h:i A') }}</div>
                        </div>

                        <div class="col-md-6">
                            <label class="text-muted small">Last Updated</label>
                            <div>{{ $business->updated_at->format('M d, Y h:i A') }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Documents -->
            @if($business->license_document || $business->registration_document)
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Documents</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            @if($business->license_document)
                                <div class="col-md-6">
                                    <div class="border rounded p-3">
                                        <div class="d-flex align-items-center mb-2">
                                            <i class="bi bi-file-earmark-pdf text-danger fs-3 me-2"></i>
                                            <div>
                                                <div class="fw-semibold">Trade License</div>
                                                <small class="text-muted">Uploaded document</small>
                                            </div>
                                        </div>
                                        <a href="{{ Storage::url($business->license_document) }}"
                                           target="_blank"
                                           class="btn btn-sm btn-outline-primary w-100">
                                            <i class="bi bi-download me-2"></i>View Document
                                        </a>
                                    </div>
                                </div>
                            @endif

                            @if($business->registration_document)
                                <div class="col-md-6">
                                    <div class="border rounded p-3">
                                        <div class="d-flex align-items-center mb-2">
                                            <i class="bi bi-file-earmark-pdf text-danger fs-3 me-2"></i>
                                            <div>
                                                <div class="fw-semibold">Registration Certificate</div>
                                                <small class="text-muted">Uploaded document</small>
                                            </div>
                                        </div>
                                        <a href="{{ Storage::url($business->registration_document) }}"
                                           target="_blank"
                                           class="btn btn-sm btn-outline-primary w-100">
                                            <i class="bi bi-download me-2"></i>View Document
                                        </a>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @endif

            <!-- Venues -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Venues</h5>
                </div>
                <div class="card-body p-0">
                    @php
                        $venues = $business->venues()->take(10)->get();
                    @endphp

                    @if($venues->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="bg-light">
                                <tr>
                                    <th>Venue Name</th>
                                    <th>Category</th>
                                    <th>City</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($venues as $venue)
                                    <tr>
                                        <td class="fw-semibold">{{ $venue->name }}</td>
                                        <td>{{ $venue->category->name ?? 'N/A' }}</td>
                                        <td>{{ $venue->city }}</td>
                                        <td>
                                            @if($venue->status === 'active')
                                                <span class="badge bg-success">Active</span>
                                            @else
                                                <span class="badge bg-secondary">{{ ucfirst($venue->status) }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.venues.show', $venue->id) }}"
                                               class="btn btn-sm btn-outline-primary">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-4 text-muted">
                            No venues registered yet
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Owner Information -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Owner Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="text-muted small">Full Name</label>
                        <div class="fw-semibold">{{ $business->owner->full_name }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Email</label>
                        <div>{{ $business->owner->email }}</div>
                    </div>

                    <div class="mb-3">
                        <label class="text-muted small">Phone</label>
                        <div>{{ $business->owner->phone ?? 'N/A' }}</div>
                    </div>

                    <div class="mb-0">
                        <label class="text-muted small">Account Status</label>
                        <div>
                            @if($business->owner->status === 'active')
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">{{ ucfirst($business->owner->status) }}</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Assign Subscription -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Assign Subscription</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.businesses.assign-subscription', $business->id) }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label class="form-label">Subscription Plan</label>
                            <select class="form-select" name="plan_id" id="planSelect" required>
                                <option value="">Select Plan</option>
                                @php
                                    $publicPlans = \App\Models\SubscriptionPlan::where('type', 'business')
                                        ->where('is_active', true)
                                        ->where('is_private', false)
                                        ->where('price', 0)
                                        ->orderBy('price')
                                        ->get();
                                    $privatePlans = \App\Models\SubscriptionPlan::where('type', 'business')
                                        ->where('is_active', true)
                                        ->where('is_private', true)
                                        ->orderBy('price')
                                        ->get();
                                @endphp

                                @if($publicPlans->count() > 0)
                                    <optgroup label="Public Plans">
                                        @foreach($publicPlans as $plan)
                                            <option value="{{ $plan->id }}"
                                                    data-price="{{ $plan->price }}"
                                                {{ $business->subscription_plan_id == $plan->id ? 'selected' : '' }}>
                                                {{ $plan->name }} - {{ $plan->price == 0 ? 'FREE' : 'AED ' . $plan->price . ' / ' . $plan->duration }}
                                            </option>
                                        @endforeach
                                    </optgroup>
                                @endif

                                @if($privatePlans->count() > 0)
                                    <optgroup label="Private Plans (Admin Only)">
                                        @foreach($privatePlans as $plan)
                                            <option value="{{ $plan->id }}"
                                                    data-price="{{ $plan->price }}"
                                                {{ $business->subscription_plan_id == $plan->id ? 'selected' : '' }}>
                                                🔒 {{ $plan->name }} - {{ $plan->price == 0 ? 'FREE' : 'AED ' . $plan->price . ' / ' . $plan->duration }}
                                            </option>
                                        @endforeach
                                    </optgroup>
                                @endif
                            </select>
                            <small class="text-muted">Private plans are only visible to admins and can be assigned manually.</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Duration (Days)</label>
                            <input type="number" class="form-control" name="duration" id="durationInput"
                                   min="1" max="3650" value="30" required>
                            <small class="text-muted d-block mt-1">
                                Quick select:
                                <a href="#" onclick="setDays(7); return false;" class="text-decoration-none">7</a> |
                                <a href="#" onclick="setDays(30); return false;" class="text-decoration-none">30</a> |
                                <a href="#" onclick="setDays(90); return false;" class="text-decoration-none">90</a> |
                                <a href="#" onclick="setDays(180); return false;" class="text-decoration-none">180</a> |
                                <a href="#" onclick="setDays(365); return false;" class="text-decoration-none">365</a> days
                            </small>
                        </div>

                        <button type="submit" class="btn btn-primary w-100">
                            <i class="bi bi-check-circle me-2"></i>Assign Subscription
                        </button>
                    </form>

                    <script>
                        function setDays(days) {
                            document.getElementById('durationInput').value = days;
                        }
                    </script>
                </div>
            </div>

            <!-- Current Subscription Info -->
            @if($business->subscription_plan_id)
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Current Subscription</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="text-muted small">Plan</label>
                            <div class="fw-semibold">{{ $business->subscriptionPlan->name ?? 'N/A' }}</div>
                        </div>

                        <div class="mb-3">
                            <label class="text-muted small">Status</label>
                            <div>
                                @if($business->subscription_status === 'active')
                                    <span class="badge bg-success">Active</span>
                                @elseif($business->subscription_status === 'expired')
                                    <span class="badge bg-danger">Expired</span>
                                @elseif($business->subscription_status === 'cancelled')
                                    <span class="badge bg-secondary">Cancelled</span>
                                @else
                                    <span class="badge bg-warning">{{ ucfirst($business->subscription_status) }}</span>
                                @endif
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="text-muted small">Start Date</label>
                            <div>{{ $business->subscription_start_date ? $business->subscription_start_date->format('M d, Y') : 'N/A' }}</div>
                        </div>

                        <div class="mb-0">
                            <label class="text-muted small">End Date</label>
                            <div>{{ $business->subscription_end_date ? $business->subscription_end_date->format('M d, Y') : 'N/A' }}</div>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Admin Actions -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-bottom">
                    <h5 class="mb-0 fw-bold">Admin Actions</h5>
                </div>
                <div class="card-body">
                    @if($business->status === 'pending')
{{--                        verify business--}}
                        <a class="btn btn-success w-100 mb-2" href="{{ route('admin.businesses.verify', $business->id) }}">
                            <i class="bi bi-check-circle me-2"></i>Verify Business
                        </a>

                    @else
                        <button class="btn btn-warning w-100 mb-2" onclick="suspendBusiness({{ $business->id }})">
                            <i class="bi bi-pause-circle me-2"></i>Suspend Business
                        </button>
                    @endif

                    <a href="{{ route('admin.users.show', $business->owner_id) }}"
                       class="btn btn-outline-primary w-100 mb-2">
                        <i class="bi bi-person me-2"></i>View Owner Profile
                    </a>

                    <button class="btn btn-outline-danger w-100" onclick="deleteBusiness({{ $business->id }})">
                        <i class="bi bi-trash me-2"></i>Delete Business
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function approveBusiness(id) {
            if (confirm('Approve this business?')) {
                fetch(`/admin/businesses/${id}/approve`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert(data.message || 'Error approving business');
                        }
                    });
            }
        }

        function rejectBusiness(id) {
            const reason = prompt('Enter rejection reason:');
            if (reason) {
                fetch(`/admin/businesses/${id}/reject`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Content-Type': 'application/json',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({ reason: reason })
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert(data.message || 'Error rejecting business');
                        }
                    });
            }
        }

        function suspendBusiness(id) {
            const reason = prompt('Enter suspension reason:');
            if (reason) {
                fetch(`/admin/businesses/${id}/suspend`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Content-Type': 'application/json',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({ reason: reason })
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert(data.message || 'Error suspending business');
                        }
                    });
            }
        }

        function deleteBusiness(id) {
            if (confirm('Are you sure you want to delete this business? This action cannot be undone.')) {
                fetch(`/admin/businesses/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json'
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            window.location.href = '/admin/businesses';
                        } else {
                            alert(data.message || 'Error deleting business');
                        }
                    });
            }
        }
    </script>
@endpush
