@extends('layouts.admin')

@section('title', 'System Configuration')

@section('content')
    <div class="admin-header mb-4">
        <div>
            <h2>System Configuration</h2>
            <p class="text-muted mb-0">Manage platform settings and configurations</p>
        </div>
        <button class="btn btn-primary" onclick="saveAllSettings()">
            <i class="bi bi-check-circle me-2"></i>Save All Changes
        </button>
    </div>

    <!-- Configuration Tabs -->
    <ul class="nav nav-tabs mb-4" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" data-bs-toggle="tab" href="#general">
                <i class="bi bi-gear me-2"></i>General
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" href="#email">
                <i class="bi bi-envelope me-2"></i>Email
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" href="#payment">
                <i class="bi bi-credit-card me-2"></i>Payment
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" href="#sms">
                <i class="bi bi-phone me-2"></i>SMS
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" href="#features">
                <i class="bi bi-toggles me-2"></i>Features
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" data-bs-toggle="tab" href="#limits">
                <i class="bi bi-speedometer me-2"></i>Limits
            </a>
        </li>
    </ul>

    <form id="configForm" method="POST" action="{{ route('admin.configuration.update') }}">
        @csrf
        @method('PUT')

        <div class="tab-content">
            <!-- General Tab -->
            <div class="tab-pane fade show active" id="general">
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Platform Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Platform Name</label>
                                <input type="text" name="platform_name" class="form-control"
                                       value="{{ config('app.name') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Platform URL</label>
                                <input type="url" name="platform_url" class="form-control"
                                       value="{{ config('app.url') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Support Email</label>
                                <input type="email" name="support_email" class="form-control"
                                       value="support@privasee.com">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Contact Phone</label>
                                <input type="text" name="contact_phone" class="form-control"
                                       value="+971 50 123 4567">
                            </div>

                            <div class="col-12">
                                <label class="form-label fw-semibold">Platform Description</label>
                                <textarea name="platform_description" class="form-control" rows="3"></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Business Settings</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="require_business_verification" checked>
                                    <label class="form-check-label">Require Business Verification</label>
                                </div>
                                <small class="text-muted">Businesses must be verified before they can create offers</small>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="require_offer_approval" checked>
                                    <label class="form-check-label">Require Offer Approval</label>
                                </div>
                                <small class="text-muted">All offers must be approved by admin</small>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Minimum Business Age (Days)</label>
                                <input type="number" name="min_business_age" class="form-control" value="0">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Trial Period (Days)</label>
                                <input type="number" name="trial_period_days" class="form-control" value="14">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Email Tab -->
            <div class="tab-pane fade" id="email">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Email Configuration</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">SMTP Host</label>
                                <input type="text" name="smtp_host" class="form-control"
                                       value="{{ config('mail.mailers.smtp.host') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">SMTP Port</label>
                                <input type="text" name="smtp_port" class="form-control"
                                       value="{{ config('mail.mailers.smtp.port') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">SMTP Username</label>
                                <input type="text" name="smtp_username" class="form-control"
                                       value="{{ config('mail.mailers.smtp.username') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">SMTP Password</label>
                                <input type="password" name="smtp_password" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">From Email</label>
                                <input type="email" name="mail_from_address" class="form-control"
                                       value="{{ config('mail.from.address') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">From Name</label>
                                <input type="text" name="mail_from_name" class="form-control"
                                       value="{{ config('mail.from.name') }}">
                            </div>

                            <div class="col-12">
                                <button type="button" class="btn btn-outline-primary" onclick="testEmail()">
                                    <i class="bi bi-envelope-check me-2"></i>Send Test Email
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payment Tab -->
            <div class="tab-pane fade" id="payment">
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Stripe Configuration</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Publishable Key</label>
                                <input type="text" name="stripe_key" class="form-control"
                                       value="{{ config('services.stripe.key') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Secret Key</label>
                                <input type="password" name="stripe_secret" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Webhook Secret</label>
                                <input type="password" name="stripe_webhook_secret" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch mt-4">
                                    <input class="form-check-input" type="checkbox" name="stripe_enabled" checked>
                                    <label class="form-check-label">Enable Stripe Payments</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">PayPal Configuration</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Client ID</label>
                                <input type="text" name="paypal_client_id" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Secret</label>
                                <input type="password" name="paypal_secret" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Mode</label>
                                <select name="paypal_mode" class="form-select">
                                    <option value="sandbox">Sandbox</option>
                                    <option value="live">Live</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch mt-4">
                                    <input class="form-check-input" type="checkbox" name="paypal_enabled">
                                    <label class="form-check-label">Enable PayPal Payments</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- SMS Tab -->
            <div class="tab-pane fade" id="sms">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Twilio Configuration</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Account SID</label>
                                <input type="text" name="twilio_sid" class="form-control"
                                       value="{{ config('services.twilio.sid') }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Auth Token</label>
                                <input type="password" name="twilio_token" class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">From Number</label>
                                <input type="text" name="twilio_from" class="form-control"
                                       value="{{ config('services.twilio.from') }}">
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch mt-4">
                                    <input class="form-check-input" type="checkbox" name="sms_enabled">
                                    <label class="form-check-label">Enable SMS Notifications</label>
                                </div>
                            </div>

                            <div class="col-12">
                                <button type="button" class="btn btn-outline-primary" onclick="testSMS()">
                                    <i class="bi bi-phone-vibrate me-2"></i>Send Test SMS
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Features Tab -->
            <div class="tab-pane fade" id="features">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">Feature Flags</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="enable_spotlights" checked>
                                    <label class="form-check-label fw-semibold">Spotlights Feature</label>
                                </div>
                                <small class="text-muted d-block mt-1">Allow users to create and share spotlights</small>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="enable_reviews" checked>
                                    <label class="form-check-label fw-semibold">Reviews & Ratings</label>
                                </div>
                                <small class="text-muted d-block mt-1">Allow users to review venues and businesses</small>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="enable_referrals" checked>
                                    <label class="form-check-label fw-semibold">Referral Program</label>
                                </div>
                                <small class="text-muted d-block mt-1">Enable business referral system</small>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="enable_notifications" checked>
                                    <label class="form-check-label fw-semibold">Push Notifications</label>
                                </div>
                                <small class="text-muted d-block mt-1">Send push notifications to users</small>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="enable_marketing" checked>
                                    <label class="form-check-label fw-semibold">Marketing Tools</label>
                                </div>
                                <small class="text-muted d-block mt-1">Marketing campaign features for businesses</small>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="enable_analytics" checked>
                                    <label class="form-check-label fw-semibold">Analytics Dashboard</label>
                                </div>
                                <small class="text-muted d-block mt-1">Advanced analytics for businesses</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Limits Tab -->
            <div class="tab-pane fade" id="limits">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="mb-0 fw-bold">System Limits</h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Max File Upload Size (MB)</label>
                                <input type="number" name="max_upload_size" class="form-control" value="10">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Max Images Per Offer</label>
                                <input type="number" name="max_offer_images" class="form-control" value="10">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Max Spotlights Per Day</label>
                                <input type="number" name="max_spotlights_per_day" class="form-control" value="5">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Max Redemptions Per User/Day</label>
                                <input type="number" name="max_redemptions_per_day" class="form-control" value="10">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">Session Timeout (Minutes)</label>
                                <input type="number" name="session_timeout" class="form-control" value="120">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label fw-semibold">API Rate Limit (Per Minute)</label>
                                <input type="number" name="api_rate_limit" class="form-control" value="60">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-4 text-end">
            <button type="button" class="btn btn-secondary" onclick="resetForm()">
                <i class="bi bi-arrow-clockwise me-2"></i>Reset Changes
            </button>
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-check-circle me-2"></i>Save All Configuration
            </button>
        </div>
    </form>
@endsection

@push('scripts')
    <script>
        function saveAllSettings() {
            document.getElementById('configForm').submit();
        }

        function resetForm() {
            if (confirm('Reset all changes? This will reload the page.')) {
                location.reload();
            }
        }

        function testEmail() {
            alert('Test email will be sent to your admin email address.');
        }

        function testSMS() {
            alert('Test SMS will be sent to your configured number.');
        }
    </script>
@endpush
