@extends('layouts.admin')

@section('title', 'Create New Role')

@section('content')
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2>Create New Role</h2>
                <p class="text-muted mb-0">Define a new role with custom permissions</p>
            </div>
            <a href="{{ route('admin.roles.index') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back to Roles
            </a>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <form action="{{ route('admin.roles.store') }}" method="POST">
                    @csrf

                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0">Role Information</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label for="name" class="form-label">Role Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                       id="name" name="name" value="{{ old('name') }}"
                                       placeholder="e.g., Content Manager" required>
                                <small class="text-muted">This will be converted to a slug (e.g., content_manager)</small>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="display_name" class="form-label">Display Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('display_name') is-invalid @enderror"
                                       id="display_name" name="display_name" value="{{ old('display_name') }}"
                                       placeholder="Content Manager" required>
                                <small class="text-muted">This is shown in the UI</small>
                                @error('display_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="type" class="form-label">Role Type <span class="text-danger">*</span></label>
                                <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                                    <option value="">Select Type</option>
                                    <option value="admin" {{ old('type') === 'admin' ? 'selected' : '' }}>Admin</option>
                                    <option value="business" {{ old('type') === 'business' ? 'selected' : '' }}>Business</option>
                                </select>
                                <small class="text-muted">Admin roles are for platform administrators, Business roles are for business users</small>
                                @error('type')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea class="form-control @error('description') is-invalid @enderror"
                                          id="description" name="description" rows="3"
                                          placeholder="Describe what this role can do">{{ old('description') }}</textarea>
                                @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0">Assign Permissions</h5>
                            <small class="text-muted">Select permissions for this role</small>
                        </div>
                        <div class="card-body">
                            @if($permissions->isEmpty())
                                <div class="alert alert-info">
                                    No permissions available. Please create permissions first.
                                </div>
                            @else
                                <div class="mb-3">
                                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="selectAllPermissions()">
                                        <i class="bi bi-check-all me-1"></i>Select All
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="deselectAllPermissions()">
                                        <i class="bi bi-x-circle me-1"></i>Deselect All
                                    </button>
                                </div>

                                @foreach($permissions as $group => $groupPermissions)
                                    <div class="permission-group mb-4">
                                        <div class="d-flex align-items-center mb-3">
                                            <h6 class="mb-0 text-primary">{{ ucfirst($group) }}</h6>
                                            <span class="badge bg-primary ms-2">{{ $groupPermissions->count() }}</span>
                                        </div>

                                        <div class="row g-3">
                                            @foreach($groupPermissions as $permission)
                                                <div class="col-md-6">
                                                    <div class="form-check">
                                                        <input class="form-check-input permission-checkbox"
                                                               type="checkbox"
                                                               name="permissions[]"
                                                               value="{{ $permission->id }}"
                                                               id="permission_{{ $permission->id }}"
                                                            {{ in_array($permission->id, old('permissions', [])) ? 'checked' : '' }}>
                                                        <label class="form-check-label" for="permission_{{ $permission->id }}">
                                                            <strong>{{ $permission->display_name }}</strong>
                                                            @if($permission->description)
                                                                <br><small class="text-muted">{{ $permission->description }}</small>
                                                            @endif
                                                        </label>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <hr>
                                @endforeach
                            @endif
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle me-2"></i>Create Role
                        </button>
                        <a href="{{ route('admin.roles.index') }}" class="btn btn-secondary">
                            Cancel
                        </a>
                    </div>
                </form>
            </div>

            <div class="col-lg-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <h6 class="card-title">
                            <i class="bi bi-info-circle text-primary me-2"></i>Role Guidelines
                        </h6>
                        <ul class="small text-muted mb-0">
                            <li>Choose a descriptive name for the role</li>
                            <li>Admin roles have access to the admin panel</li>
                            <li>Business roles have access to the business dashboard</li>
                            <li>Assign only necessary permissions</li>
                            <li>You can modify permissions later</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function selectAllPermissions() {
            document.querySelectorAll('.permission-checkbox').forEach(checkbox => {
                checkbox.checked = true;
            });
        }

        function deselectAllPermissions() {
            document.querySelectorAll('.permission-checkbox').forEach(checkbox => {
                checkbox.checked = false;
            });
        }
    </script>

    <style>
        .permission-group {
            background: #f8f9fa;
            padding: 1.5rem;
            border-radius: 0.5rem;
        }

        .form-check {
            padding: 0.75rem;
            background: white;
            border-radius: 0.375rem;
            border: 1px solid #e9ecef;
        }

        .form-check:hover {
            border-color: #cbd5e0;
            background: #f8f9fa;
        }
    </style>
@endsection
