@extends('layouts.admin')

@section('title', 'Edit Role')

@section('content')
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2>Edit Role: {{ $role->display_name }}</h2>
                <p class="text-muted mb-0">Update role information and permissions</p>
            </div>
            <a href="{{ route('admin.roles.index') }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back to Roles
            </a>
        </div>

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <div class="row">
            <div class="col-lg-8">
                <form action="{{ route('admin.roles.update', $role->id) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-white py-3">
                            <h5 class="mb-0">Role Information</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Role Name (Slug)</label>
                                <input type="text" class="form-control" value="{{ $role->name }}" disabled>
                                <small class="text-muted">Role slug cannot be changed</small>
                            </div>

                            <div class="mb-3">
                                <label for="display_name" class="form-label">Display Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('display_name') is-invalid @enderror"
                                       id="display_name" name="display_name"
                                       value="{{ old('display_name', $role->display_name) }}" required>
                                @error('display_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Role Type</label>
                                <input type="text" class="form-control" value="{{ ucfirst($role->type) }}" disabled>
                                <small class="text-muted">Role type cannot be changed</small>
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea class="form-control @error('description') is-invalid @enderror"
                                          id="description" name="description" rows="3">{{ old('description', $role->description) }}</textarea>
                                @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0">Permissions</h5>
                                <small class="text-muted">Manage permissions for this role</small>
                            </div>
                            <div>
                                <button type="button" class="btn btn-sm btn-outline-primary" onclick="selectAllPermissions()">
                                    <i class="bi bi-check-all me-1"></i>Select All
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="deselectAllPermissions()">
                                    <i class="bi bi-x-circle me-1"></i>Clear All
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            @foreach($permissions as $group => $groupPermissions)
                                <div class="permission-group mb-4">
                                    <div class="d-flex align-items-center mb-3">
                                        <h6 class="mb-0 text-primary">{{ ucfirst($group) }}</h6>
                                        <span class="badge bg-primary ms-2">{{ $groupPermissions->count() }}</span>
                                    </div>

                                    <div class="row g-3">
                                        @foreach($groupPermissions as $permission)
                                            <div class="col-md-6">
                                                <div class="form-check">
                                                    <input class="form-check-input permission-checkbox"
                                                           type="checkbox"
                                                           name="permissions[]"
                                                           value="{{ $permission->id }}"
                                                           id="permission_{{ $permission->id }}"
                                                        {{ in_array($permission->id, old('permissions', $rolePermissionIds)) ? 'checked' : '' }}>
                                                    <label class="form-check-label" for="permission_{{ $permission->id }}">
                                                        <strong>{{ $permission->display_name }}</strong>
                                                        @if($permission->description)
                                                            <br><small class="text-muted">{{ $permission->description }}</small>
                                                        @endif
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                @if(!$loop->last)
                                    <hr>
                                @endif
                            @endforeach
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle me-2"></i>Update Role
                        </button>
                        <a href="{{ route('admin.roles.index') }}" class="btn btn-secondary">
                            Cancel
                        </a>
                    </div>
                </form>
            </div>

            <div class="col-lg-4">
                <div class="card border-0 shadow-sm mb-3">
                    <div class="card-body">
                        <h6 class="card-title">
                            <i class="bi bi-info-circle text-primary me-2"></i>Role Statistics
                        </h6>
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Current Permissions:</span>
                            <strong>{{ $role->permissions->count() }}</strong>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Assigned Users:</span>
                            <strong>{{ $role->users->count() }}</strong>
                        </div>
                        <div class="d-flex justify-content-between">
                            <span class="text-muted">Role Type:</span>
                            <strong>{{ ucfirst($role->type) }}</strong>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <h6 class="card-title">
                            <i class="bi bi-shield-exclamation text-warning me-2"></i>Important Notes
                        </h6>
                        <ul class="small text-muted mb-0">
                            <li>Changes affect all users with this role</li>
                            <li>Removing permissions may restrict user access</li>
                            <li>Always test changes with a test user first</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function selectAllPermissions() {
            document.querySelectorAll('.permission-checkbox').forEach(checkbox => {
                checkbox.checked = true;
            });
        }

        function deselectAllPermissions() {
            document.querySelectorAll('.permission-checkbox').forEach(checkbox => {
                checkbox.checked = false;
            });
        }
    </script>

    <style>
        .permission-group {
            background: #f8f9fa;
            padding: 1.5rem;
            border-radius: 0.5rem;
        }

        .form-check {
            padding: 0.75rem;
            background: white;
            border-radius: 0.375rem;
            border: 1px solid #e9ecef;
        }

        .form-check:hover {
            border-color: #cbd5e0;
            background: #f8f9fa;
        }

        .form-check-input:checked + .form-check-label {
            color: #0d6efd;
        }
    </style>
@endsection
