@extends('layouts.admin')

@section('title', 'Roles Management')

@section('content')
    <div class="admin-header mb-4">
        <div>
            <h2>Roles & Permissions</h2>
            <p class="text-muted mb-0">Manage system roles and their permissions dynamically</p>
        </div>
        <a href="{{ route('admin.roles.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i>Create New Role
        </a>
    </div>

    <!-- Alert Messages -->
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="bi bi-exclamation-triangle me-2"></i>{{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Stats Cards -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="stat-icon bg-primary bg-opacity-10 text-primary">
                                <i class="bi bi-shield-check"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <div class="text-muted small">Total Roles</div>
                            <h3 class="mb-0">{{ $stats['total'] }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="stat-icon bg-success bg-opacity-10 text-success">
                                <i class="bi bi-person-workspace"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <div class="text-muted small">Admin Roles</div>
                            <h3 class="mb-0">{{ $stats['admin'] }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="stat-icon bg-info bg-opacity-10 text-info">
                                <i class="bi bi-briefcase"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <div class="text-muted small">Business Roles</div>
                            <h3 class="mb-0">{{ $stats['business'] }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="stat-icon bg-warning bg-opacity-10 text-warning">
                                <i class="bi bi-lock"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <div class="text-muted small">System Roles</div>
                            <h3 class="mb-0">{{ $stats['system'] }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Tabs -->
    <ul class="nav nav-tabs mb-4">
        <li class="nav-item">
            <a class="nav-link {{ $type === 'all' ? 'active' : '' }}" href="{{ route('admin.roles.index', ['type' => 'all']) }}">
                All Roles ({{ $stats['total'] }})
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ $type === 'admin' ? 'active' : '' }}" href="{{ route('admin.roles.index', ['type' => 'admin']) }}">
                Admin ({{ $stats['admin'] }})
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ $type === 'business' ? 'active' : '' }}" href="{{ route('admin.roles.index', ['type' => 'business']) }}">
                Business ({{ $stats['business'] }})
            </a>
        </li>
    </ul>

    <!-- Roles Table -->
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                    <tr>
                        <th>Role Name</th>
                        <th>Type</th>
                        <th>Description</th>
                        <th>Permissions</th>
                        <th>Users</th>
                        <th>Status</th>
                        <th class="text-end">Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($roles as $role)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="me-3">
                                        <div class="avatar-sm bg-{{ $role->type === 'admin' ? 'primary' : 'success' }} bg-opacity-10 text-{{ $role->type === 'admin' ? 'primary' : 'success' }} rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-shield-{{ $role->is_system ? 'lock' : 'check' }}"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="fw-bold">{{ $role->display_name }}</div>
                                        <div class="text-muted small">{{ $role->name }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                            <span class="badge bg-{{ $role->type === 'admin' ? 'primary' : 'success' }}">
                                {{ ucfirst($role->type) }}
                            </span>
                            </td>
                            <td>
                                <span class="text-muted">{{ Str::limit($role->description, 50) ?? 'No description' }}</span>
                            </td>
                            <td>
                                <span class="badge bg-info">{{ $role->permissions->count() }} permissions</span>
                            </td>
                            <td>
                                <a href="{{ route('admin.roles.users', $role->id) }}" class="text-decoration-none">
                                    {{ $role->users->count() }} users
                                </a>
                            </td>
                            <td>
                                @if($role->is_system)
                                    <span class="badge bg-warning">System Role</span>
                                @else
                                    <span class="badge bg-success">Custom</span>
                                @endif
                            </td>
                            <td>
                                <div class="d-flex justify-content-end gap-2">
                                    <a href="{{ route('admin.roles.show', $role->id) }}" class="btn btn-sm btn-light" title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.roles.permissions', $role->id) }}" class="btn btn-sm btn-info" title="Manage Permissions">
                                        <i class="bi bi-shield-lock"></i>
                                    </a>
                                    @if(!$role->is_system)
                                        <a href="{{ route('admin.roles.edit', $role->id) }}" class="btn btn-sm btn-primary" title="Edit">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button onclick="deleteRole({{ $role->id }}, '{{ $role->display_name }}')" class="btn btn-sm btn-danger" title="Delete">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-5">
                                <i class="bi bi-shield-x" style="font-size: 3rem; color: #ccc;"></i>
                                <p class="text-muted mt-3">No roles found</p>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                {{ $roles->links() }}
            </div>
        </div>
    </div>

    <style>
        .avatar-sm {
            width: 40px;
            height: 40px;
            font-size: 1.2rem;
        }

        .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }
    </style>

    <script>
        function deleteRole(id, name) {
            if (!confirm(`Are you sure you want to delete the role "${name}"?`)) {
                return;
            }

            fetch(`/admin/roles/${id}`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        window.location.reload();
                    } else {
                        alert(data.message || 'Error deleting role');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error deleting role');
                });
        }
    </script>
@endsection
