@extends('layouts.admin')

@section('title', 'Manage Role Permissions')

@section('content')
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2>Manage Permissions: {{ $role->display_name }}</h2>
                <p class="text-muted mb-0">Assign or remove permissions for this role</p>
            </div>
            <a href="{{ route('admin.roles.show', $role->id) }}" class="btn btn-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back to Role
            </a>
        </div>

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <div class="row">
            <div class="col-lg-9">
                <form action="{{ route('admin.roles.permissions.update', $role->id) }}" method="POST" id="permissionsForm">
                    @csrf

                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-white py-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="mb-0">Available Permissions</h5>
                                    <small class="text-muted">Select permissions to grant this role</small>
                                </div>
                                <div>
                                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="selectAllPermissions()">
                                        <i class="bi bi-check-all me-1"></i>Select All
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="deselectAllPermissions()">
                                        <i class="bi bi-x-circle me-1"></i>Clear All
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            @if($allPermissions->isEmpty())
                                <div class="alert alert-info">
                                    <i class="bi bi-info-circle me-2"></i>
                                    No permissions available. Please create permissions first.
                                </div>
                            @else
                                @foreach($allPermissions as $group => $permissions)
                                    <div class="permission-group mb-4">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <div>
                                                <h6 class="mb-0 text-primary">
                                                    <i class="bi bi-folder me-2"></i>{{ ucfirst($group) }}
                                                </h6>
                                            </div>
                                            <div>
                                                <span class="badge bg-primary">{{ $permissions->count() }} permissions</span>
                                                <button type="button" class="btn btn-sm btn-outline-primary" onclick="selectGroup('group_{{ $loop->index }}')">
                                                    <i class="bi bi-check-all"></i>
                                                </button>
                                            </div>
                                        </div>

                                        <div class="row g-3">
                                            @foreach($permissions as $permission)
                                                <div class="col-md-6">
                                                    <div class="form-check permission-item">
                                                        <input class="form-check-input permission-checkbox group_{{ $loop->parent->index }}"
                                                               type="checkbox"
                                                               name="permissions[]"
                                                               value="{{ $permission->id }}"
                                                               id="permission_{{ $permission->id }}"
                                                               {{ $role->permissions->contains($permission->id) ? 'checked' : '' }}
                                                               onchange="updateCounter()">
                                                        <label class="form-check-label w-100" for="permission_{{ $permission->id }}">
                                                            <div class="d-flex justify-content-between align-items-start">
                                                                <div>
                                                                    <strong>{{ $permission->display_name }}</strong>
                                                                    <br><small class="text-muted">{{ $permission->name }}</small>
                                                                    @if($permission->description)
                                                                        <br><small class="text-muted">{{ $permission->description }}</small>
                                                                    @endif
                                                                </div>
                                                                @if($role->permissions->contains($permission->id))
                                                                    <span class="badge bg-success">Current</span>
                                                                @endif
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    @if(!$loop->last)
                                        <hr>
                                    @endif
                                @endforeach
                            @endif
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle me-2"></i>Save Permissions
                        </button>
                        <a href="{{ route('admin.roles.show', $role->id) }}" class="btn btn-secondary">
                            Cancel
                        </a>
                    </div>
                </form>
            </div>

            <div class="col-lg-3">
                <div class="card border-0 shadow-sm mb-3 sticky-top" style="top: 20px;">
                    <div class="card-body">
                        <h6 class="card-title">
                            <i class="bi bi-info-circle text-primary me-2"></i>Permission Summary
                        </h6>
                        <div class="mb-3">
                            <div class="d-flex justify-content-between mb-2">
                                <span class="text-muted">Total Available:</span>
                                <strong id="totalPermissions">{{ $allPermissions->flatten()->count() }}</strong>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span class="text-muted">Currently Assigned:</span>
                                <strong class="text-success" id="currentCount">{{ $role->permissions->count() }}</strong>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span class="text-muted">Selected:</span>
                                <strong class="text-primary" id="selectedCount">{{ $role->permissions->count() }}</strong>
                            </div>
                        </div>
                        <div class="progress" style="height: 5px;">
                            <div class="progress-bar" role="progressbar" id="progressBar"
                                 style="width: {{ $allPermissions->flatten()->count() > 0 ? ($role->permissions->count() / $allPermissions->flatten()->count() * 100) : 0 }}%"></div>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm">
                    <div class="card-body">
                        <h6 class="card-title">
                            <i class="bi bi-shield-exclamation text-warning me-2"></i>Important
                        </h6>
                        <ul class="small text-muted mb-0">
                            <li>Changes apply to all {{ $role->users->count() }} users with this role</li>
                            <li>Removing permissions may restrict access</li>
                            <li>Test changes before deploying</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        const totalPermissions = {{ $allPermissions->flatten()->count() }};

        function selectAllPermissions() {
            document.querySelectorAll('.permission-checkbox').forEach(checkbox => {
                checkbox.checked = true;
            });
            updateCounter();
        }

        function deselectAllPermissions() {
            document.querySelectorAll('.permission-checkbox').forEach(checkbox => {
                checkbox.checked = false;
            });
            updateCounter();
        }

        function selectGroup(groupClass) {
            document.querySelectorAll(`.${groupClass}`).forEach(checkbox => {
                checkbox.checked = true;
            });
            updateCounter();
        }

        function updateCounter() {
            const checked = document.querySelectorAll('.permission-checkbox:checked').length;
            document.getElementById('selectedCount').textContent = checked;

            const percentage = totalPermissions > 0 ? (checked / totalPermissions * 100) : 0;
            document.getElementById('progressBar').style.width = percentage + '%';
        }

        // Initialize counter on page load
        document.addEventListener('DOMContentLoaded', function() {
            updateCounter();
        });
    </script>

    <style>
        .permission-group {
            background: #f8f9fa;
            padding: 1.5rem;
            border-radius: 0.5rem;
        }

        .permission-item {
            padding: 1rem;
            background: white;
            border-radius: 0.375rem;
            border: 1px solid #e9ecef;
            transition: all 0.2s;
        }

        .permission-item:hover {
            border-color: #0d6efd;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .permission-item input:checked + label {
            color: #0d6efd;
        }

        .form-check-input {
            width: 1.25rem;
            height: 1.25rem;
            margin-top: 0.25rem;
        }
    </style>
@endsection
