@extends('layouts.admin')

@section('title', 'Role Details')

@section('content')
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2>{{ $role->display_name }}</h2>
                <p class="text-muted mb-0">{{ $role->description ?? 'No description available' }}</p>
            </div>
            <div class="d-flex gap-2">
                @if(!$role->is_system)
                    <a href="{{ route('admin.roles.edit', $role->id) }}" class="btn btn-primary">
                        <i class="bi bi-pencil me-2"></i>Edit Role
                    </a>
                @endif
                <a href="{{ route('admin.roles.index') }}" class="btn btn-secondary">
                    <i class="bi bi-arrow-left me-2"></i>Back
                </a>
            </div>
        </div>

        <div class="row g-4">
            <!-- Role Info Card -->
            <div class="col-md-4">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">Role Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="text-muted small">Role Name (Slug)</label>
                            <p class="mb-0"><code>{{ $role->name }}</code></p>
                        </div>
                        <div class="mb-3">
                            <label class="text-muted small">Display Name</label>
                            <p class="mb-0 fw-bold">{{ $role->display_name }}</p>
                        </div>
                        <div class="mb-3">
                            <label class="text-muted small">Type</label>
                            <p class="mb-0">
                            <span class="badge bg-{{ $role->type === 'admin' ? 'primary' : 'success' }}">
                                {{ ucfirst($role->type) }}
                            </span>
                            </p>
                        </div>
                        <div class="mb-3">
                            <label class="text-muted small">Status</label>
                            <p class="mb-0">
                                @if($role->is_system)
                                    <span class="badge bg-warning">System Role</span>
                                @else
                                    <span class="badge bg-success">Custom Role</span>
                                @endif
                            </p>
                        </div>
                        <div class="mb-3">
                            <label class="text-muted small">Created</label>
                            <p class="mb-0">{{ $role->created_at->format('M d, Y') }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stats Cards -->
            <div class="col-md-8">
                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <div class="card border-0 shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0">
                                        <div class="stat-icon bg-primary bg-opacity-10 text-primary">
                                            <i class="bi bi-shield-check"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <div class="text-muted small">Total Permissions</div>
                                        <h3 class="mb-0">{{ $permissionCount }}</h3>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <a href="{{ route('admin.roles.permissions', $role->id) }}" class="btn btn-sm btn-outline-primary w-100">
                                        <i class="bi bi-gear me-2"></i>Manage Permissions
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card border-0 shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0">
                                        <div class="stat-icon bg-success bg-opacity-10 text-success">
                                            <i class="bi bi-people"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <div class="text-muted small">Assigned Users</div>
                                        <h3 class="mb-0">{{ $userCount }}</h3>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <a href="{{ route('admin.roles.users', $role->id) }}" class="btn btn-sm btn-outline-success w-100">
                                        <i class="bi bi-person-lines-fill me-2"></i>View Users
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Permissions List -->
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Assigned Permissions</h5>
                        @if(!$role->is_system)
                            <a href="{{ route('admin.roles.permissions', $role->id) }}" class="btn btn-sm btn-primary">
                                <i class="bi bi-plus-circle me-1"></i>Manage
                            </a>
                        @endif
                    </div>
                    <div class="card-body">
                        @if($role->permissions->isEmpty())
                            <div class="text-center py-5">
                                <i class="bi bi-shield-x" style="font-size: 3rem; color: #ccc;"></i>
                                <p class="text-muted mt-3">No permissions assigned</p>
                                @if(!$role->is_system)
                                    <a href="{{ route('admin.roles.permissions', $role->id) }}" class="btn btn-primary">
                                        <i class="bi bi-plus-circle me-2"></i>Assign Permissions
                                    </a>
                                @endif
                            </div>
                        @else
                            @php
                                $groupedPermissions = $role->permissions->groupBy('group');
                            @endphp

                            @foreach($groupedPermissions as $group => $permissions)
                                <div class="mb-4">
                                    <h6 class="text-primary mb-3">
                                        <i class="bi bi-folder me-2"></i>{{ ucfirst($group) }}
                                        <span class="badge bg-primary ms-2">{{ $permissions->count() }}</span>
                                    </h6>
                                    <div class="row g-2">
                                        @foreach($permissions as $permission)
                                            <div class="col-md-6">
                                                <div class="permission-badge">
                                                    <i class="bi bi-check-circle text-success me-2"></i>
                                                    <strong>{{ $permission->display_name }}</strong>
                                                    @if($permission->description)
                                                        <br><small class="text-muted ms-4">{{ $permission->description }}</small>
                                                    @endif
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                @if(!$loop->last)
                                    <hr>
                                @endif
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Users Section -->
        @if($userCount > 0)
            <div class="card border-0 shadow-sm mt-4">
                <div class="card-header bg-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Recent Users with This Role</h5>
                    <a href="{{ route('admin.roles.users', $role->id) }}" class="btn btn-sm btn-outline-primary">
                        View All {{ $userCount }} Users
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                            <tr>
                                <th>User</th>
                                <th>Email</th>
                                <th>Business</th>
                                <th>Assigned Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($role->users->take(5) as $user)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-sm bg-primary bg-opacity-10 text-primary rounded-circle d-flex align-items-center justify-content-center me-2">
                                                {{ strtoupper(substr($user->name, 0, 1)) }}
                                            </div>
                                            <strong>{{ $user->name }}</strong>
                                        </div>
                                    </td>
                                    <td>{{ $user->email }}</td>
                                    <td>
                                        @if($user->businesses->isNotEmpty())
                                            {{ $user->businesses->first()->name }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>{{ $user->pivot->created_at->format('M d, Y') }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif
    </div>

    <style>
        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }

        .permission-badge {
            padding: 0.75rem;
            background: #f8f9fa;
            border-radius: 0.375rem;
            border-left: 3px solid #198754;
        }

        .avatar-sm {
            width: 35px;
            height: 35px;
            font-size: 0.875rem;
        }
    </style>
@endsection
