@extends('layouts.admin')

@section('title', 'Spotlight Management')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col">
            <h2 class="mb-3">Spotlight Management</h2>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1">Total Posts</p>
                            <h3 class="mb-0">{{ number_format($stats['total']) }}</h3>
                        </div>
                        <div class="bg-primary bg-opacity-10 rounded p-3">
                            <i class="bi bi-lightning-fill text-primary fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1">Active</p>
                            <h3 class="mb-0">{{ number_format($stats['active']) }}</h3>
                        </div>
                        <div class="bg-success bg-opacity-10 rounded p-3">
                            <i class="bi bi-check-circle-fill text-success fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1">Pending Review</p>
                            <h3 class="mb-0">{{ number_format($stats['pending']) }}</h3>
                        </div>
                        <div class="bg-warning bg-opacity-10 rounded p-3">
                            <i class="bi bi-clock-fill text-warning fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <p class="text-muted mb-1">Flagged</p>
                            <h3 class="mb-0">{{ number_format($stats['flagged']) }}</h3>
                        </div>
                        <div class="bg-danger bg-opacity-10 rounded p-3">
                            <i class="bi bi-flag-fill text-danger fs-4"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters & Table -->
    <div class="card">
        <div class="card-header bg-white">
            <div class="row align-items-center">
                <div class="col-md-4">
                    <form action="{{ route('admin.spotlights.index') }}" method="GET">
                        <div class="input-group">
                            <input type="text" class="form-control" name="search" placeholder="Search posts..." value="{{ request('search') }}">
                            <button class="btn btn-outline-secondary" type="submit">
                                <i class="bi bi-search"></i>
                            </button>
                        </div>
                    </form>
                </div>
                <div class="col-md-8 text-end">
                    <div class="btn-group" role="group">
                        <a href="{{ route('admin.spotlights.index') }}" class="btn btn-sm {{ !request('status') ? 'btn-primary' : 'btn-outline-primary' }}">
                            All
                        </a>
                        <a href="{{ route('admin.spotlights.index', ['status' => 'pending']) }}" class="btn btn-sm {{ request('status') === 'pending' ? 'btn-warning' : 'btn-outline-warning' }}">
                            Pending
                        </a>
                        <a href="{{ route('admin.spotlights.index', ['status' => 'active']) }}" class="btn btn-sm {{ request('status') === 'active' ? 'btn-success' : 'btn-outline-success' }}">
                            Active
                        </a>
                        <a href="{{ route('admin.spotlights.index', ['flagged' => 1]) }}" class="btn btn-sm {{ request('flagged') ? 'btn-danger' : 'btn-outline-danger' }}">
                            Flagged
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th width="60">ID</th>
                            <th>Content</th>
                            <th>User</th>
                            <th>Venue</th>
                            <th>Engagement</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th width="150">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($spotlights as $spotlight)
                        <tr>
                            <td>#{{ $spotlight->id }}</td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @if($spotlight->media && count(json_decode($spotlight->media)) > 0)
                                        <img src="{{ Storage::url(json_decode($spotlight->media)[0]) }}"
                                             class="rounded me-2" width="50" height="50" style="object-fit: cover;">
                                    @endif
                                    <div>
                                        <p class="mb-0 text-truncate" style="max-width: 300px;">
                                            {{ $spotlight->content }}
                                        </p>
                                        @if($spotlight->is_flagged)
                                            <span class="badge bg-danger">
                                                <i class="bi bi-flag-fill me-1"></i>Flagged
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div>
                                        <div class="fw-medium">{{ $spotlight->user->full_name }}</div>
                                        <small class="text-muted">{{ $spotlight->user->email }}</small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                @if($spotlight->venue)
                                    <span class="badge bg-info">{{ $spotlight->venue->name }}</span>
                                @else
                                    <span class="text-muted">—</span>
                                @endif
                            </td>
                            <td>
                                <div class="d-flex gap-2">
                                    <span class="badge bg-light text-dark">
                                        <i class="bi bi-heart-fill text-danger"></i> {{ $spotlight->likes_count }}
                                    </span>
                                    <span class="badge bg-light text-dark">
                                        <i class="bi bi-chat-fill text-primary"></i> {{ $spotlight->comments_count }}
                                    </span>
                                </div>
                            </td>
                            <td>
                                @if($spotlight->status === 'active')
                                    <span class="badge bg-success">Active</span>
                                @elseif($spotlight->status === 'pending')
                                    <span class="badge bg-warning">Pending</span>
                                @else
                                    <span class="badge bg-danger">Rejected</span>
                                @endif
                            </td>
                            <td>
                                <small>{{ $spotlight->created_at->format('M d, Y') }}</small>
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('admin.spotlights.show', $spotlight->id) }}"
                                       class="btn btn-outline-primary" title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    @if($spotlight->status === 'pending')
                                        <button onclick="approveSpotlight({{ $spotlight->id }})"
                                                class="btn btn-outline-success" title="Approve">
                                            <i class="bi bi-check"></i>
                                        </button>
                                        <button onclick="rejectSpotlight({{ $spotlight->id }})"
                                                class="btn btn-outline-danger" title="Reject">
                                            <i class="bi bi-x"></i>
                                        </button>
                                    @endif
                                    @if($spotlight->is_flagged)
                                        <button onclick="unflagSpotlight({{ $spotlight->id }})"
                                                class="btn btn-outline-warning" title="Unflag">
                                            <i class="bi bi-flag"></i>
                                        </button>
                                    @endif
                                    <button onclick="deleteSpotlight({{ $spotlight->id }})"
                                            class="btn btn-outline-danger" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center py-5">
                                <i class="bi bi-inbox text-muted" style="font-size: 48px;"></i>
                                <p class="text-muted mt-2">No spotlight posts found</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        @if($spotlights->hasPages())
        <div class="card-footer">
            {{ $spotlights->links() }}
        </div>
        @endif
    </div>
</div>

<script>
function approveSpotlight(id) {
    if (confirm('Approve this spotlight post?')) {
        fetch(`/admin/spotlights/${id}/approve`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        });
    }
}

function rejectSpotlight(id) {
    const reason = prompt('Reason for rejection (optional):');
    if (reason !== null) {
        fetch(`/admin/spotlights/${id}/reject`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ notes: reason })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        });
    }
}

function unflagSpotlight(id) {
    if (confirm('Remove flag from this post?')) {
        fetch(`/admin/spotlights/${id}/unflag`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        });
    }
}

function deleteSpotlight(id) {
    if (confirm('Are you sure you want to delete this spotlight post? This cannot be undone.')) {
        fetch(`/admin/spotlights/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        });
    }
}
</script>
@endsection
