@extends('layouts.admin')

@section('title', 'Subscriptions Management')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Subscriptions Management</h2>
            <p class="text-muted mb-0">View all active subscriptions</p>
        </div>
    </div>

    <div class="admin-card">
        <div class="admin-card-header">
            <h5 class="mb-0 fw-bold">All Subscriptions</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                    <tr>
                        <th>Business</th>
                        <th>Plan</th>
                        <th>Status</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Auto Renew</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($subscriptions as $subscription)
                        <tr>
                            <td>{{ $subscription->business->business_name ?? 'N/A' }}</td>
                            <td><strong>{{ $subscription->plan->name ?? 'N/A' }}</strong></td>
                            <td>
                            <span class="badge bg-{{ $subscription->status === 'active' ? 'success' : ($subscription->status === 'trial' ? 'info' : 'secondary') }}">
                                {{ ucfirst($subscription->status) }}
                            </span>
                            </td>
                            <td>{{ $subscription->start_date ? $subscription->start_date->format('M d, Y') : 'N/A' }}</td>
                            <td>{{ $subscription->end_date ? $subscription->end_date->format('M d, Y') : 'N/A' }}</td>
                            <td>
                                @if($subscription->auto_renew)
                                    <i class="bi bi-check-circle-fill text-success"></i> Yes
                                @else
                                    <i class="bi bi-x-circle-fill text-danger"></i> No
                                @endif
                            </td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary" onclick="viewSubscription({{ $subscription->id }})">
                                    <i class="bi bi-eye me-1"></i>View
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">No subscriptions found</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if(isset($subscriptions) && $subscriptions->hasPages())
            <div class="admin-card-footer">
                {{ $subscriptions->links() }}
            </div>
        @endif
    </div>
@endsection

@push('scripts')
    <script>
        function viewSubscription(id) {
            fetch(`/admin/subscriptions/${id}`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        showSubscriptionModal(data.subscription);
                    }
                });
        }

        function showSubscriptionModal(subscription) {
            const modalHtml = `
        <div class="modal fade" id="viewSubscriptionModal" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Subscription Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <strong>Business:</strong> ${subscription.business?.business_name || 'N/A'}
                            </div>
                            <div class="col-md-6">
                                <strong>Plan:</strong> ${subscription.plan?.name || 'N/A'}
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <strong>Status:</strong> <span class="badge bg-${subscription.status === 'active' ? 'success' : 'secondary'}">${subscription.status}</span>
                            </div>
                            <div class="col-md-6">
                                <strong>Auto Renew:</strong> ${subscription.auto_renew ? 'Yes' : 'No'}
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <strong>Start Date:</strong> ${subscription.start_date || 'N/A'}
                            </div>
                            <div class="col-md-6">
                                <strong>End Date:</strong> ${subscription.end_date || 'N/A'}
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <strong>Current Period Start:</strong> ${subscription.current_period_start || 'N/A'}
                            </div>
                            <div class="col-md-6">
                                <strong>Current Period End:</strong> ${subscription.current_period_end || 'N/A'}
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    `;

            document.body.insertAdjacentHTML('beforeend', modalHtml);
            const modal = new bootstrap.Modal(document.getElementById('viewSubscriptionModal'));
            modal.show();

            document.getElementById('viewSubscriptionModal').addEventListener('hidden.bs.modal', function () {
                this.remove();
            });
        }
    </script>
@endpush
