@extends('layouts.guest')

@section('title', 'Business Registration')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card shadow-lg border-0">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                        <h2 class="fw-bold mb-2">Register Your Business</h2>
                        <p class="text-muted">Join Privasee and start attracting more customers</p>
                    </div>

                    @if($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('business.register.submit') }}" method="POST" enctype="multipart/form-data" id="registrationForm">
                        @csrf

                        <!-- Progress Steps -->
                        <div class="mb-4">
                            <div class="d-flex justify-content-between">
                                <div class="step active" data-step="1">
                                    <div class="step-circle">1</div>
                                    <small>Owner Info</small>
                                </div>
                                <div class="step-line"></div>
                                <div class="step" data-step="2">
                                    <div class="step-circle">2</div>
                                    <small>Business Details</small>
                                </div>
                                <div class="step-line"></div>
                                <div class="step" data-step="3">
                                    <div class="step-circle">3</div>
                                    <small>Documents</small>
                                </div>
                            </div>
                        </div>

                        <!-- Step 1: Owner Information -->
                        <div class="form-step active" id="step1">
                            <h5 class="mb-3 fw-bold">Owner Information</h5>

                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">First Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="owner_first_name" value="{{ old('owner_first_name') }}" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Last Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="owner_last_name" value="{{ old('owner_last_name') }}" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Email <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" name="owner_email" value="{{ old('owner_email') }}" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Phone <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control" name="owner_phone" value="{{ old('owner_phone') }}" placeholder="+971501234567" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="password" required>
                                    <small class="text-muted">Minimum 8 characters</small>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Confirm Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="password_confirmation" required>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end mt-4">
                                <button type="button" class="btn btn-primary" onclick="nextStep(2)">
                                    Next <i class="bi bi-arrow-right ms-2"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Step 2: Business Details -->
                        <div class="form-step" id="step2">
                            <h5 class="mb-3 fw-bold">Business Details</h5>

                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Business Name (English) <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="business_name" id="businessName" value="{{ old('business_name') }}" required>
                                    <small class="text-success" id="nameAvailable" style="display: none;">
                                        <i class="bi bi-check-circle"></i> Available
                                    </small>
                                    <small class="text-danger" id="nameUnavailable" style="display: none;">
                                        <i class="bi bi-x-circle"></i> Already taken
                                    </small>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Business Name (Arabic)</label>
                                    <input type="text" class="form-control" name="business_name_ar" value="{{ old('business_name_ar') }}" dir="rtl">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Trade License Number <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="trade_license_number" id="licenseNumber" value="{{ old('trade_license_number') }}" required>
                                    <small class="text-success" id="licenseAvailable" style="display: none;">
                                        <i class="bi bi-check-circle"></i> Available
                                    </small>
                                    <small class="text-danger" id="licenseUnavailable" style="display: none;">
                                        <i class="bi bi-x-circle"></i> Already registered
                                    </small>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Business Email <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" name="email" value="{{ old('email') }}" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Business Phone <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control" name="phone" value="{{ old('phone') }}" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Website</label>
                                    <input type="url" class="form-control" name="website" value="{{ old('website') }}" placeholder="https://example.com">
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Business Description (English)</label>
                                    <textarea class="form-control" name="description" rows="3">{{ old('description') }}</textarea>
                                </div>

                                <div class="col-12">
                                    <label class="form-label">Business Description (Arabic)</label>
                                    <textarea class="form-control" name="description_ar" rows="3" dir="rtl">{{ old('description_ar') }}</textarea>
                                </div>
                            </div>

                            <div class="d-flex justify-content-between mt-4">
                                <button type="button" class="btn btn-outline-secondary" onclick="prevStep(1)">
                                    <i class="bi bi-arrow-left me-2"></i> Back
                                </button>
                                <button type="button" class="btn btn-primary" onclick="nextStep(3)">
                                    Next <i class="bi bi-arrow-right ms-2"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Step 3: Documents & Images -->
                        <div class="form-step" id="step3">
                            <h5 class="mb-3 fw-bold">Documents & Images</h5>

                            <div class="row g-3">
                                <div class="col-12">
                                    <label class="form-label">Trade License Document <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control" name="trade_license_document" accept=".pdf,.jpg,.jpeg,.png" required>
                                    <small class="text-muted">PDF, JPG, or PNG (Max 5MB)</small>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Business Logo</label>
                                    <input type="file" class="form-control" name="logo" accept="image/*" onchange="previewImage(this, 'logoPreview')">
                                    <small class="text-muted">PNG or JPG (Max 2MB)</small>
                                    <div class="mt-2">
                                        <img id="logoPreview" src="" style="max-width: 150px; display: none;" class="img-thumbnail">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Cover Image</label>
                                    <input type="file" class="form-control" name="cover_image" accept="image/*" onchange="previewImage(this, 'coverPreview')">
                                    <small class="text-muted">PNG or JPG (Max 2MB)</small>
                                    <div class="mt-2">
                                        <img id="coverPreview" src="" style="max-width: 150px; display: none;" class="img-thumbnail">
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="termsCheck" required>
                                        <label class="form-check-label" for="termsCheck">
                                            I agree to the <a href="#" target="_blank">Terms & Conditions</a> and <a href="#" target="_blank">Privacy Policy</a>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-between mt-4">
                                <button type="button" class="btn btn-outline-secondary" onclick="prevStep(2)">
                                    <i class="bi bi-arrow-left me-2"></i> Back
                                </button>
                                <button type="submit" class="btn btn-success">
                                    <i class="bi bi-check-circle me-2"></i> Register Business
                                </button>
                            </div>
                        </div>
                    </form>

                    <div class="text-center mt-4">
                        <p class="mb-0">Already have an account? <a href="{{ route('business.login') }}">Login here</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.step {
    text-align: center;
    flex: 1;
}

.step-circle {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #e9ecef;
    color: #6c757d;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 8px;
    font-weight: bold;
    transition: all 0.3s;
}

.step.active .step-circle {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.step-line {
    height: 2px;
    background: #e9ecef;
    align-self: center;
    flex: 1;
    margin: 0 10px;
}

.form-step {
    display: none;
}

.form-step.active {
    display: block;
    animation: fadeIn 0.3s;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>

<script>
function nextStep(step) {
    document.querySelectorAll('.form-step').forEach(s => s.classList.remove('active'));
    document.querySelectorAll('.step').forEach(s => s.classList.remove('active'));

    document.getElementById('step' + step).classList.add('active');
    document.querySelector('.step[data-step="' + step + '"]').classList.add('active');
}

function prevStep(step) {
    nextStep(step);
}

function previewImage(input, previewId) {
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const preview = document.getElementById(previewId);
            preview.src = e.target.result;
            preview.style.display = 'block';
        }
        reader.readAsDataURL(input.files[0]);
    }
}

// Check business name availability
let nameTimeout;
document.getElementById('businessName')?.addEventListener('input', function() {
    clearTimeout(nameTimeout);
    const name = this.value;

    if (name.length < 3) return;

    nameTimeout = setTimeout(() => {
        fetch('/business/check-availability', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ business_name: name })
        })
        .then(res => res.json())
        .then(data => {
            if (data.business_name_available) {
                document.getElementById('nameAvailable').style.display = 'block';
                document.getElementById('nameUnavailable').style.display = 'none';
            } else {
                document.getElementById('nameAvailable').style.display = 'none';
                document.getElementById('nameUnavailable').style.display = 'block';
            }
        });
    }, 500);
});

// Check license availability
let licenseTimeout;
document.getElementById('licenseNumber')?.addEventListener('input', function() {
    clearTimeout(licenseTimeout);
    const license = this.value;

    if (license.length < 3) return;

    licenseTimeout = setTimeout(() => {
        fetch('/business/check-availability', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ license: license })
        })
        .then(res => res.json())
        .then(data => {
            if (data.license_available) {
                document.getElementById('licenseAvailable').style.display = 'block';
                document.getElementById('licenseUnavailable').style.display = 'none';
            } else {
                document.getElementById('licenseAvailable').style.display = 'none';
                document.getElementById('licenseUnavailable').style.display = 'block';
            }
        });
    }, 500);
});
</script>
@endsection
