@extends('layouts.business')

@section('title', 'Help & Support Center')

@section('content')
<div class="text-center mb-5">
    <h2 class="fw-bold mb-2">How can we help you?</h2>
    <p class="text-muted mb-4">Search our knowledge base or contact support</p>

    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="input-group input-group-lg">
                <span class="input-group-text bg-white"><i class="bi bi-search"></i></span>
                <input type="text" class="form-control" placeholder="Search for help articles...">
                <button class="btn btn-primary px-4">Search</button>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row g-4 mb-5">
    <div class="col-md-4">
        <div class="card border-0 shadow-sm h-100 text-center p-4">
            <div class="mx-auto mb-3" style="width: 60px; height: 60px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 1rem; display: flex; align-items: center; justify-content: center;">
                <i class="bi bi-chat-dots text-white fs-3"></i>
            </div>
            <h5 class="fw-bold">Live Chat</h5>
            <p class="text-muted">Chat with our support team</p>
            <button class="btn btn-outline-primary mt-auto">Start Chat</button>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card border-0 shadow-sm h-100 text-center p-4">
            <div class="mx-auto mb-3" style="width: 60px; height: 60px; background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); border-radius: 1rem; display: flex; align-items: center; justify-content: center;">
                <i class="bi bi-envelope text-white fs-3"></i>
            </div>
            <h5 class="fw-bold">Email Support</h5>
            <p class="text-muted">Send us an email</p>
            <a href="mailto:support@privasee.com" class="btn btn-outline-primary mt-auto">Send Email</a>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card border-0 shadow-sm h-100 text-center p-4">
            <div class="mx-auto mb-3" style="width: 60px; height: 60px; background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); border-radius: 1rem; display: flex; align-items: center; justify-content: center;">
                <i class="bi bi-ticket-perforated text-white fs-3"></i>
            </div>
            <h5 class="fw-bold">Support Tickets</h5>
            <p class="text-muted">View your tickets</p>
            <a href="{{ route('business.support.tickets') }}" class="btn btn-outline-primary mt-auto">My Tickets</a>
        </div>
    </div>
</div>

<!-- Popular Categories -->
<div class="mb-5">
    <h4 class="fw-bold mb-4">Browse by Category</h4>
    <div class="row g-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <i class="bi bi-rocket-takeoff fs-2 text-primary mb-3"></i>
                    <h6 class="fw-bold">Getting Started</h6>
                    <p class="text-muted small">Setup and basics</p>
                    <a href="#" class="stretched-link"></a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <i class="bi bi-geo-alt fs-2 text-success mb-3"></i>
                    <h6 class="fw-bold">Venue Management</h6>
                    <p class="text-muted small">Add and manage venues</p>
                    <a href="#" class="stretched-link"></a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <i class="bi bi-tag fs-2 text-warning mb-3"></i>
                    <h6 class="fw-bold">Offers & Promotions</h6>
                    <p class="text-muted small">Create and manage offers</p>
                    <a href="#" class="stretched-link"></a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <i class="bi bi-people fs-2 text-info mb-3"></i>
                    <h6 class="fw-bold">Team Management</h6>
                    <p class="text-muted small">Manage your team</p>
                    <a href="#" class="stretched-link"></a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <i class="bi bi-credit-card fs-2 text-danger mb-3"></i>
                    <h6 class="fw-bold">Billing & Subscription</h6>
                    <p class="text-muted small">Payment and plans</p>
                    <a href="#" class="stretched-link"></a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <i class="bi bi-graph-up fs-2 text-primary mb-3"></i>
                    <h6 class="fw-bold">Analytics & Reports</h6>
                    <p class="text-muted small">Track performance</p>
                    <a href="#" class="stretched-link"></a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <i class="bi bi-qr-code fs-2 text-success mb-3"></i>
                    <h6 class="fw-bold">Redemptions</h6>
                    <p class="text-muted small">Manage redemptions</p>
                    <a href="#" class="stretched-link"></a>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <i class="bi bi-gear fs-2 text-secondary mb-3"></i>
                    <h6 class="fw-bold">Technical Issues</h6>
                    <p class="text-muted small">Troubleshooting</p>
                    <a href="#" class="stretched-link"></a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Popular Articles -->
<div class="mb-5">
    <h4 class="fw-bold mb-4">Popular Articles</h4>
    <div class="table-card">
        <div class="list-group list-group-flush">
            <a href="#" class="list-group-item list-group-item-action">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-1">How to create your first offer</h6>
                        <small class="text-muted">Step-by-step guide to creating promotional offers</small>
                    </div>
                    <i class="bi bi-chevron-right"></i>
                </div>
            </a>
            <a href="#" class="list-group-item list-group-item-action">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-1">Adding and managing venues</h6>
                        <small class="text-muted">Learn how to add multiple venue locations</small>
                    </div>
                    <i class="bi bi-chevron-right"></i>
                </div>
            </a>
            <a href="#" class="list-group-item list-group-item-action">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-1">Inviting team members</h6>
                        <small class="text-muted">Manage your team and set permissions</small>
                    </div>
                    <i class="bi bi-chevron-right"></i>
                </div>
            </a>
            <a href="#" class="list-group-item list-group-item-action">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-1">Understanding redemption codes</h6>
                        <small class="text-muted">How QR codes and redemptions work</small>
                    </div>
                    <i class="bi bi-chevron-right"></i>
                </div>
            </a>
            <a href="#" class="list-group-item list-group-item-action">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-1">Subscription plans explained</h6>
                        <small class="text-muted">Choose the right plan for your business</small>
                    </div>
                    <i class="bi bi-chevron-right"></i>
                </div>
            </a>
        </div>
    </div>
</div>

<!-- Video Tutorials -->
<div class="mb-5">
    <h4 class="fw-bold mb-4">Video Tutorials</h4>
    <div class="row g-4">
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="bg-light" style="height: 200px; display: flex; align-items: center; justify-content: center;">
                    <i class="bi bi-play-circle fs-1 text-primary"></i>
                </div>
                <div class="card-body">
                    <h6 class="fw-bold">Getting Started with Privasee</h6>
                    <small class="text-muted">5:32</small>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="bg-light" style="height: 200px; display: flex; align-items: center; justify-content: center;">
                    <i class="bi bi-play-circle fs-1 text-primary"></i>
                </div>
                <div class="card-body">
                    <h6 class="fw-bold">Creating Your First Offer</h6>
                    <small class="text-muted">7:15</small>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="bg-light" style="height: 200px; display: flex; align-items: center; justify-content: center;">
                    <i class="bi bi-play-circle fs-1 text-primary"></i>
                </div>
                <div class="card-body">
                    <h6 class="fw-bold">Managing Team Members</h6>
                    <small class="text-muted">4:50</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Contact Information -->
<div class="text-center py-5 bg-light rounded-3">
    <h4 class="fw-bold mb-3">Still need help?</h4>
    <p class="text-muted mb-4">Our support team is here to assist you</p>
    <div class="row justify-content-center g-4">
        <div class="col-md-4">
            <i class="bi bi-envelope fs-3 text-primary mb-2"></i>
            <div class="fw-semibold">Email</div>
            <a href="mailto:support@privasee.com" class="text-decoration-none">support@privasee.com</a>
        </div>
        <div class="col-md-4">
            <i class="bi bi-telephone fs-3 text-success mb-2"></i>
            <div class="fw-semibold">Phone</div>
            <a href="tel:+971123456789" class="text-decoration-none">+971 12 345 6789</a>
        </div>
        <div class="col-md-4">
            <i class="bi bi-clock fs-3 text-info mb-2"></i>
            <div class="fw-semibold">Hours</div>
            <div class="text-muted">9 AM - 6 PM (GST)</div>
        </div>
    </div>
</div>
@endsection
