@extends('layouts.business')

@section('title', 'Marketing Packages')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="h3 mb-3">Marketing Toolkit</h1>
            <p class="text-muted">Boost your visibility and reach more customers</p>
        </div>
    </div>

    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <p class="text-muted mb-1">Active Campaigns</p>
                            <h3 class="mb-0">{{ $activeCampaigns }}</h3>
                        </div>
                        <div class="text-primary">
                            <i class="fas fa-chart-line fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <p class="text-muted mb-1">Total Spent</p>
                            <h3 class="mb-0">AED {{ number_format($totalSpent, 2) }}</h3>
                        </div>
                        <div class="text-success">
                            <i class="fas fa-money-bill-wave fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <a href="{{ route('business.marketing.campaigns') }}" class="btn btn-primary btn-block">
                        <i class="fas fa-list"></i> View My Campaigns
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Marketing Packages -->
    @foreach($packages as $type => $typePackages)
    <div class="row mb-4">
        <div class="col-12">
            <h4 class="mb-3 text-capitalize">{{ str_replace('_', ' ', $type) }}</h4>
        </div>

        @foreach($typePackages as $package)
        <div class="col-md-4 mb-3">
            <div class="card h-100">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">{{ $package->name }}</h5>
                </div>
                <div class="card-body">
                    <div class="text-center mb-3">
                        <h2 class="mb-0">AED {{ number_format($package->price, 2) }}</h2>
                        <p class="text-muted">{{ $package->duration_days }} days</p>
                    </div>

                    <p class="text-muted">{{ $package->description }}</p>

                    @if($package->features)
                    <ul class="list-unstyled">
                        @foreach($package->features as $feature)
                        <li class="mb-2">
                            <i class="fas fa-check text-success"></i> {{ $feature }}
                        </li>
                        @endforeach
                    </ul>
                    @endif

                    @if($package->max_impressions)
                    <p class="text-muted small">
                        <i class="fas fa-eye"></i> Up to {{ number_format($package->max_impressions) }} impressions
                    </p>
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('business.marketing.create', $package->id) }}" class="btn btn-primary btn-block">
                        <i class="fas fa-plus"></i> Create Campaign
                    </a>
                </div>
            </div>
        </div>
        @endforeach
    </div>
    @endforeach
</div>
@endsection
