@extends('layouts.business')

@section('title', 'Create New Offer')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Create New Offer</h2>
        <p class="text-muted mb-0">Create an attractive offer for your customers</p>
    </div>
    <a href="{{ route('business.offers.index') }}" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left me-2"></i>Back to Offers
    </a>
</div>
{{-- display errors--}}
@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<form action="{{ route('business.offers.store') }}" method="POST" enctype="multipart/form-data">
    @csrf

    <div class="row g-4">
        <!-- Left Column -->
        <div class="col-lg-8">
            <!-- Basic Information -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Basic Information</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Title (English) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('title') is-invalid @enderror"
                                   name="title" value="{{ old('title') }}" required placeholder="e.g., 50% Off All Items">
                            @error('title')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Title (Arabic)</label>
                            <input type="text" class="form-control @error('title_ar') is-invalid @enderror"
                                   name="title_ar" value="{{ old('title_ar') }}" dir="rtl" placeholder="خصم 50٪ على جميع المنتجات">
                            @error('title_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description (English) <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('description') is-invalid @enderror"
                                      name="description" rows="4" required>{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description (Arabic)</label>
                            <textarea class="form-control @error('description_ar') is-invalid @enderror"
                                      name="description_ar" rows="4" dir="rtl">{{ old('description_ar') }}</textarea>
                            @error('description_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Venues <span class="text-danger">*</span></label>
                            <select
                                class="form-select @error('venue_ids') is-invalid @enderror"
                                name="venue_ids[]"
                                multiple
                                required
                            >
                                @foreach($venues ?? [] as $venue)
                                    <option value="{{ $venue->id }}"
                                        {{ (collect(old('venue_ids'))->contains($venue->id)) ? 'selected' : '' }}>
                                        {{ $venue->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('venue_ids')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Hold Ctrl (Windows) or Command (Mac) to select multiple venues.</small>
                        </div>



                        <div class="col-md-6">
                            <label class="form-label">Category</label>
                            <select class="form-select @error('category_id') is-invalid @enderror" name="category_id">
                                <option value="">Select Category</option>
                                @foreach($categories ?? [] as $category)
                                    <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                        {{ $category->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('category_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <!-- Discount Details -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Discount Details</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Offer Type <span class="text-danger">*</span></label>
                            <select class="form-select @error('offer_type') is-invalid @enderror" name="offer_type" required>
                                <option value="regular" {{ old('offer_type') === 'regular' ? 'selected' : '' }}>Regular</option>
                                <option value="special" {{ old('offer_type') === 'special' ? 'selected' : '' }}>Special</option>
                                <option value="exclusive" {{ old('offer_type') === 'exclusive' ? 'selected' : '' }}>Exclusive</option>
                            </select>
                            @error('offer_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Discount Type <span class="text-danger">*</span></label>
                            <select class="form-select @error('discount_type') is-invalid @enderror"
                                    name="discount_type" id="discountType" required>
                                <option value="percentage" {{ old('discount_type') === 'percentage' ? 'selected' : '' }}>Percentage Off</option>
                                <option value="fixed" {{ old('discount_type') === 'fixed' ? 'selected' : '' }}>Fixed Amount Off</option>
                                <option value="bogo" {{ old('discount_type') === 'bogo' ? 'selected' : '' }}>Buy One Get One</option>
                                <option value="free" {{ old('discount_type') === 'free' ? 'selected' : '' }}>Free Item/Service</option>
                            </select>
                            @error('discount_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4" id="discountValueField">
                            <label class="form-label">Discount Value <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="number" class="form-control @error('discount_value') is-invalid @enderror"
                                       name="discount_value" value="{{ old('discount_value') }}" step="0.01">
                                <span class="input-group-text" id="discountUnit">%</span>
                            </div>
                            @error('discount_value')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Original Price</label>
                            <div class="input-group">
                                <span class="input-group-text">AED</span>
                                <input type="number" class="form-control @error('original_price') is-invalid @enderror"
                                       name="original_price" value="{{ old('original_price') }}" step="0.01">
                            </div>
                            @error('original_price')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">Discounted Price</label>
                            <div class="input-group">
                                <span class="input-group-text">AED</span>
                                <input type="number" class="form-control @error('discounted_price') is-invalid @enderror"
                                       name="discounted_price" value="{{ old('discounted_price') }}" step="0.01">
                            </div>
                            @error('discounted_price')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <!-- Terms & Conditions -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Terms & Conditions</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-12">
                            <label class="form-label">Terms & Conditions (English)</label>
                            <textarea class="form-control @error('terms_conditions') is-invalid @enderror"
                                      name="terms_conditions" rows="4">{{ old('terms_conditions') }}</textarea>
                            @error('terms_conditions')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">List any restrictions or requirements</small>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Terms & Conditions (Arabic)</label>
                            <textarea class="form-control @error('terms_conditions_ar') is-invalid @enderror"
                                      name="terms_conditions_ar" rows="4" dir="rtl">{{ old('terms_conditions_ar') }}</textarea>
                            @error('terms_conditions_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Column -->
        <div class="col-lg-4">
            <!-- Validity Period -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Validity Period</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Start Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                               name="start_date" value="{{ old('start_date', date('Y-m-d')) }}" required>
                        @error('start_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label">End Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                               name="end_date" value="{{ old('end_date') }}" required>
                        @error('end_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Redemption Limits -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Redemption Limits</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Total Redemption Limit</label>
                        <input type="number" class="form-control @error('redemption_limit') is-invalid @enderror"
                               name="redemption_limit" value="{{ old('redemption_limit') }}" min="1">
                        @error('redemption_limit')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Leave empty for unlimited</small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Per User Limit <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('redemption_per_user') is-invalid @enderror"
                               name="redemption_per_user" value="{{ old('redemption_per_user', 1) }}" min="1" required>
                        @error('redemption_per_user')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">How many times each user can redeem</small>
                    </div>
                </div>
            </div>

            <!-- Images -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Images</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Featured Image <span class="text-danger">*</span></label>
                        <input type="file" class="form-control @error('featured_image') is-invalid @enderror"
                               name="featured_image" accept="image/*" required>
                        @error('featured_image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Main offer image (1200x630px recommended)</small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Gallery Images</label>
                        <input type="file" class="form-control @error('images') is-invalid @enderror"
                               name="images[]" accept="image/*" multiple>
                        @error('images')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Additional images (optional)</small>
                    </div>
                </div>
            </div>

            <!-- Status & Settings -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Status & Settings</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="status">
                            <option value="draft">Save as Draft</option>
                            <option value="pending_approval" selected>Submit for Approval</option>
                        </select>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="is_featured" id="isFeatured" value="1">
                        <label class="form-check-label" for="isFeatured">
                            Featured Offer
                        </label>
                        <small class="d-block text-muted">Show in featured section</small>
                    </div>

                    <div class="alert alert-info small">
                        <i class="bi bi-info-circle me-2"></i>
                        Your offer will be reviewed by our team before going live.
                    </div>
                </div>
            </div>

            <!-- Submit Buttons -->
            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="bi bi-check-lg me-2"></i>Create Offer
                </button>
                <a href="{{ route('business.offers.index') }}" class="btn btn-outline-secondary">
                    Cancel
                </a>
            </div>
        </div>
    </div>
</form>
@endsection

@push('scripts')
<script>
    // Update discount unit based on type
    document.getElementById('discountType').addEventListener('change', function() {
        const unit = document.getElementById('discountUnit');
        const field = document.getElementById('discountValueField');

        if (this.value === 'percentage') {
            unit.textContent = '%';
            field.style.display = 'block';
        } else if (this.value === 'fixed') {
            unit.textContent = 'AED';
            field.style.display = 'block';
        } else {
            field.style.display = 'none';
        }
    });

    // Set minimum end date to start date
    document.querySelector('[name="start_date"]').addEventListener('change', function() {
        document.querySelector('[name="end_date"]').min = this.value;
    });
</script>
@endpush
