@extends('layouts.business')

@section('title', 'Offers Management')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Offers Management</h2>
        <p class="text-muted mb-0">Create and manage your promotional offers</p>
    </div>
    <a href="{{ route('business.offers.create') }}" class="btn btn-primary">
        <i class="bi bi-plus-lg me-2"></i>Create New Offer
    </a>
</div>

<!-- Stats Cards -->
<div class="row g-4 mb-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <i class="bi bi-tag text-white"></i>
            </div>
            <div class="stat-label">Total Offers</div>
            <div class="stat-value">{{ $stats['total'] ?? 0 }}</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                <i class="bi bi-check-circle text-white"></i>
            </div>
            <div class="stat-label">Active Offers</div>
            <div class="stat-value">{{ $stats['active'] ?? 0 }}</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
                <i class="bi bi-clock-history text-white"></i>
            </div>
            <div class="stat-label">Pending Approval</div>
            <div class="stat-value">{{ $stats['pending'] ?? 0 }}</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                <i class="bi bi-qr-code text-white"></i>
            </div>
            <div class="stat-label">Total Redemptions</div>
            <div class="stat-value">{{ number_format($stats['redemptions'] ?? 0) }}</div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="table-card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-3">
                <input type="text" class="form-control" name="search" placeholder="Search offers..." value="{{ request('search') }}">
            </div>
            <div class="col-md-2">
                <select class="form-select" name="status">
                    <option value="">All Status</option>
                    <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                    <option value="draft" {{ request('status') === 'draft' ? 'selected' : '' }}>Draft</option>
                    <option value="expired" {{ request('status') === 'expired' ? 'selected' : '' }}>Expired</option>
                    <option value="pending_approval" {{ request('status') === 'pending_approval' ? 'selected' : '' }}>Pending</option>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select" name="type">
                    <option value="">All Types</option>
                    <option value="exclusive" {{ request('type') === 'exclusive' ? 'selected' : '' }}>Exclusive</option>
                    <option value="special" {{ request('type') === 'special' ? 'selected' : '' }}>Special</option>
                    <option value="regular" {{ request('type') === 'regular' ? 'selected' : '' }}>Regular</option>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select" name="venue_id">
                    <option value="">All Venues</option>
                    @foreach($venues ?? [] as $venue)
                        <option value="{{ $venue->id }}" {{ request('venue_id') == $venue->id ? 'selected' : '' }}>
                            {{ $venue->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="{{ route('business.offers.index') }}" class="btn btn-outline-secondary">
                    <i class="bi bi-x-lg me-2"></i>Clear
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Offers Grid -->
<div class="row g-4">
    @forelse($offers as $offer)
    <div class="col-md-6 col-lg-4">
        <div class="card h-100 border-0 shadow-sm">
            <div class="position-relative">
                @if($offer->featured_image)
                    <img src="{{ $offer->featured_image }}" class="card-img-top" alt="{{ $offer->title }}" style="height: 200px; object-fit: cover;">
                @else
                    <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                        <i class="bi bi-image text-muted" style="font-size: 3rem;"></i>
                    </div>
                @endif

                <div class="position-absolute top-0 end-0 m-2">
                    @if($offer->offer_type === 'exclusive')
                        <span class="badge" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                            <i class="bi bi-star-fill me-1"></i>Exclusive
                        </span>
                    @elseif($offer->offer_type === 'special')
                        <span class="badge bg-warning">Special</span>
                    @endif
                </div>

                <div class="position-absolute top-0 start-0 m-2">
                    @if($offer->is_featured)
                        <span class="badge bg-success">Featured</span>
                    @endif
                </div>

                <div class="position-absolute bottom-0 start-0 m-2">
                    @if($offer->status === 'active')
                        <span class="badge bg-success">Active</span>
                    @elseif($offer->status === 'draft')
                        <span class="badge bg-secondary">Draft</span>
                    @elseif($offer->status === 'expired')
                        <span class="badge bg-danger">Expired</span>
                    @elseif($offer->status === 'pending_approval')
                        <span class="badge bg-warning">Pending Approval</span>
                    @endif
                </div>

                @if($offer->discount_type === 'percentage')
                    <div class="position-absolute bottom-0 end-0 m-2">
                        <div class="badge bg-danger fs-5">-{{ $offer->discount_value }}%</div>
                    </div>
                @endif
            </div>

            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start mb-2">
                    <h5 class="card-title fw-bold mb-0">{{ Str::limit($offer->title, 40) }}</h5>
                </div>

                <p class="text-muted small mb-2">
                    <i class="bi bi-geo-alt me-1"></i>{{ $offer->venue->name ?? 'All Venues' }}
                </p>

                <p class="card-text small text-muted mb-3">{{ Str::limit($offer->description, 80) }}</p>

                <div class="row g-2 mb-3 small">
                    <div class="col-6">
                        <div class="text-muted">Views</div>
                        <div class="fw-semibold">{{ number_format($offer->view_count) }}</div>
                    </div>
                    <div class="col-6">
                        <div class="text-muted">Redemptions</div>
                        <div class="fw-semibold">{{ $offer->redemption_count }}/{{ $offer->redemption_limit ?? '∞' }}</div>
                    </div>
                    <div class="col-6">
                        <div class="text-muted">Start Date</div>
                        <div class="fw-semibold">{{ $offer->start_date->format('M d, Y') }}</div>
                    </div>
                    <div class="col-6">
                        <div class="text-muted">End Date</div>
                        <div class="fw-semibold">{{ $offer->end_date->format('M d, Y') }}</div>
                    </div>
                </div>

                <div class="d-flex gap-2">
                    <a href="{{ route('business.offers.show', $offer->id) }}" class="btn btn-sm btn-outline-primary flex-fill">
                        <i class="bi bi-eye me-1"></i>View
                    </a>
                    <a href="{{ route('business.offers.edit', $offer->id) }}" class="btn btn-sm btn-primary flex-fill">
                        <i class="bi bi-pencil me-1"></i>Edit
                    </a>
                    <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $offer->id }}">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Delete Modal -->
        <div class="modal fade" id="deleteModal{{ $offer->id }}" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header border-0">
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-center py-4">
                        <i class="bi bi-exclamation-triangle text-danger" style="font-size: 4rem;"></i>
                        <h5 class="mt-3">Delete Offer?</h5>
                        <p class="text-muted">Are you sure you want to delete <strong>{{ $offer->title }}</strong>?</p>
                        <p class="text-danger small">This will affect {{ $offer->redemption_count }} existing redemptions.</p>
                    </div>
                    <div class="modal-footer border-0 justify-content-center">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <form action="{{ route('business.offers.destroy', $offer->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">Yes, Delete</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @empty
    <div class="col-12">
        <div class="text-center py-5">
            <i class="bi bi-tag fs-1 text-muted d-block mb-3"></i>
            <h5>No offers found</h5>
            <p class="text-muted">Start creating amazing offers for your customers</p>
            <a href="{{ route('business.offers.create') }}" class="btn btn-primary mt-3">
                <i class="bi bi-plus-lg me-2"></i>Create Your First Offer
            </a>
        </div>
    </div>
    @endforelse
</div>

{{--@if($offers->links())--}}
{{--<div class="mt-4">--}}
{{--    {{ $offers->links() }}--}}
{{--</div>--}}
{{--@endif--}}
@endsection
