@extends('layouts.business')

@section('title', 'Notification Preferences')

@section('content')
    <div class="mb-4">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2 class="fw-bold mb-1">Notification Preferences</h2>
                <p class="text-muted mb-0">Manage how you receive notifications</p>
            </div>
            <a href="{{ route('business.notifications.index') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Back
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <form action="{{ route('business.settings.update-notifications') }}" method="POST">
                        @csrf

                        <div class="mb-4">
                            <h5 class="fw-bold mb-3">Notification Channels</h5>

                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="email_notifications" id="email_notifications"
                                    {{ ($preferences['email_notifications'] ?? true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="email_notifications">
                                    <strong>Email Notifications</strong><br>
                                    <small class="text-muted">Receive notifications via email</small>
                                </label>
                            </div>

                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="push_notifications" id="push_notifications"
                                    {{ ($preferences['push_notifications'] ?? true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="push_notifications">
                                    <strong>Push Notifications</strong><br>
                                    <small class="text-muted">Receive browser push notifications</small>
                                </label>
                            </div>

                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="sms_notifications" id="sms_notifications"
                                    {{ ($preferences['sms_notifications'] ?? false) ? 'checked' : '' }}>
                                <label class="form-check-label" for="sms_notifications">
                                    <strong>SMS Notifications</strong><br>
                                    <small class="text-muted">Receive important alerts via SMS</small>
                                </label>
                            </div>
                        </div>

                        <hr>

                        <div class="mb-4">
                            <h5 class="fw-bold mb-3">Marketing Communications</h5>

                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" name="marketing_emails" id="marketing_emails"
                                    {{ ($preferences['marketing_emails'] ?? true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="marketing_emails">
                                    <strong>Marketing Emails</strong><br>
                                    <small class="text-muted">Receive tips, updates, and promotional content</small>
                                </label>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle me-2"></i>Save Preferences
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card border-0 shadow-sm bg-light">
                <div class="card-body">
                    <h6 class="fw-bold mb-3">
                        <i class="bi bi-info-circle text-primary me-2"></i>About Notifications
                    </h6>
                    <p class="small mb-2">
                        <strong>Email Notifications:</strong> Important updates about your business, offers, and redemptions.
                    </p>
                    <p class="small mb-2">
                        <strong>Push Notifications:</strong> Real-time alerts in your browser.
                    </p>
                    <p class="small mb-2">
                        <strong>SMS Notifications:</strong> Critical alerts sent to your phone.
                    </p>
                    <p class="small mb-0">
                        <strong>Marketing Emails:</strong> Tips, best practices, and platform updates.
                    </p>
                </div>
            </div>
        </div>
    </div>
@endsection
