@extends('layouts.business')

@section('title', 'Subscription Plans')

@section('content')
    <div class="mb-4">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2 class="fw-bold mb-1">Choose Your Plan</h2>
                <p class="text-muted mb-0">Select the perfect plan for your business needs</p>
            </div>
{{--            <a href="{{ route('business.subscription') }}" class="btn btn-outline-secondary">--}}
{{--                <i class="bi bi-arrow-left me-2"></i>Back to Subscription--}}
{{--            </a>--}}
        </div>
    </div>

    @if($currentSubscription)
        <div class="alert alert-info border-0 shadow-sm mb-4">
            <div class="d-flex align-items-center">
                <i class="bi bi-info-circle fs-4 me-3"></i>
                <div>
                    <strong>Current Plan:</strong> {{ $currentSubscription->plan->name ?? 'Unknown' }}
                    <span class="ms-2 text-muted">
                (Valid until {{ $currentSubscription->end_date ? $currentSubscription->end_date->format('M d, Y') : 'N/A' }})
            </span>
                </div>
            </div>
        </div>
    @endif

    <!-- Pricing Cards -->
    <div class="row g-4 mb-5">
        @forelse($plans as $plan)
            <div class="col-md-6 col-lg-4">
                <div class="card border-0 shadow-sm h-100 {{ $currentSubscription && $currentSubscription->subscription_plan_id == $plan->id ? 'border-primary' : '' }}"
                     style="position: relative; overflow: visible;">

                    @if($plan->is_popular)
                        <div class="position-absolute top-0 start-50 translate-middle">
                <span class="badge bg-warning text-dark px-3 py-2 rounded-pill shadow-sm">
                    <i class="bi bi-star-fill me-1"></i>Most Popular
                </span>
                        </div>
                    @endif

                    @if($currentSubscription && $currentSubscription->subscription_plan_id == $plan->id)
                        <div class="position-absolute top-0 end-0 m-3">
                <span class="badge bg-primary px-3 py-2">
                    <i class="bi bi-check-circle me-1"></i>Current Plan
                </span>
                        </div>
                    @endif

                    <div class="card-body p-4" style="{{ $plan->is_popular ? 'padding-top: 3rem !important;' : '' }}">
                        <!-- Plan Header -->
                        <div class="text-center mb-4">
                            <h3 class="fw-bold mb-2">{{ $plan->name }}</h3>
                            <p class="text-muted mb-3">{{ $plan->description }}</p>
                            <div class="mb-3">
                                @if($plan->price == 0)
                                    <span class="display-4 fw-bold text-success">FREE</span>
                                @else
                                    <span class="display-4 fw-bold">AED {{ number_format($plan->price, 0) }}</span>
                                    <span class="text-muted">/ {{ $plan->interval ?? 'month' }}</span>
                                @endif
                            </div>

                            @if($currentSubscription && $currentSubscription->subscription_plan_id == $plan->id)
                                <button class="btn btn-outline-primary w-100" disabled>
                                    <i class="bi bi-check-circle me-2"></i>Your Current Plan
                                </button>
                            @else
                                @if($plan->price == 0)
                                    <form action="{{ route('business.subscription.upgrade') }}" method="POST">
                                        @csrf
                                        <input type="hidden" name="plan_id" value="{{ $plan->id }}">
                                        <button type="submit" class="btn btn-success w-100">
                                            <i class="bi bi-check-circle me-2"></i>Activate Free Plan
                                        </button>
                                    </form>
                                @else
                                    <button class="btn {{ $plan->is_popular ? 'btn-primary' : 'btn-outline-primary' }} w-100"
                                            data-bs-toggle="modal"
                                            data-bs-target="#selectPlanModal"
                                            onclick="selectPlan({{ $plan->id }}, '{{ $plan->name }}', {{ $plan->price }})">
                                        <i class="bi bi-arrow-right-circle me-2"></i>
                                        {{ $currentSubscription ? 'Switch to This Plan' : 'Get Started' }}
                                    </button>
                                @endif
                            @endif
                        </div>

                        <!-- Plan Features -->
                        <div class="border-top pt-4">
                            <h6 class="fw-bold mb-3">Features Included:</h6>
                            <ul class="list-unstyled mb-0">
                                @if($plan->max_venues)
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                                        <strong>{{ $plan->max_venues }}</strong> Venue{{ $plan->max_venues > 1 ? 's' : '' }}
                                    </li>
                                @else
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                                        <strong>Unlimited</strong> Venues
                                    </li>
                                @endif

                                @if($plan->max_offers)
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                                        <strong>{{ $plan->max_offers }}</strong> Active Offer{{ $plan->max_offers > 1 ? 's' : '' }}
                                    </li>
                                @else
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                                        <strong>Unlimited</strong> Offers
                                    </li>
                                @endif

                                @if($plan->max_staff)
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                                        <strong>{{ $plan->max_staff }}</strong> Team Member{{ $plan->max_staff > 1 ? 's' : '' }}
                                    </li>
                                @else
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                                        <strong>Unlimited</strong> Team Members
                                    </li>
                                @endif

                                @if($plan->features && is_array($plan->features))
                                    @foreach($plan->features as $feature)
                                        <li class="mb-2">
                                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                                            {{ $feature }}
                                        </li>
                                    @endforeach
                                @else
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                                        Analytics Dashboard
                                    </li>
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                                        Marketing Tools
                                    </li>
                                    <li class="mb-2">
                                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                                        Priority Support
                                    </li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="card border-0 shadow-sm">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-inbox" style="font-size: 4rem; color: #ccc;"></i>
                        <h4 class="mt-3 mb-2">No Plans Available</h4>
                        <p class="text-muted">Please contact support for assistance.</p>
                    </div>
                </div>
            </div>
        @endforelse
    </div>

    <!-- FAQ Section -->
    <div class="row justify-content-center mb-5">
        <div class="col-lg-8">
            <h3 class="fw-bold mb-4 text-center">Frequently Asked Questions</h3>

            <div class="accordion" id="faqAccordion">
                <div class="accordion-item border-0 shadow-sm mb-3">
                    <h2 class="accordion-header">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                            Can I change my plan later?
                        </button>
                    </h2>
                    <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Yes! You can upgrade or downgrade your plan at any time. Changes take effect immediately.
                        </div>
                    </div>
                </div>

                <div class="accordion-item border-0 shadow-sm mb-3">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                            What payment methods do you accept?
                        </button>
                    </h2>
                    <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            We accept all major credit cards, PayPal, and bank transfers for annual plans.
                        </div>
                    </div>
                </div>

                <div class="accordion-item border-0 shadow-sm mb-3">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3">
                            Can I cancel my subscription?
                        </button>
                    </h2>
                    <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Yes, you can cancel anytime. You'll continue to have access until the end of your billing period.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Select Plan Modal -->
    <div class="modal fade" id="selectPlanModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Confirm Plan Selection</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form action="{{ route('business.subscription.upgrade') }}" method="POST">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" name="plan_id" id="selected_plan_id">

                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            You are about to subscribe to <strong id="selected_plan_name"></strong> plan.
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Payment Method</label>
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="radio" name="payment_method" id="stripe" value="stripe" checked>
                                <label class="form-check-label" for="stripe">
                                    <i class="bi bi-credit-card me-2"></i>Credit Card (Stripe)
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="payment_method" id="paypal" value="paypal">
                                <label class="form-check-label" for="paypal">
                                    <i class="bi bi-paypal me-2"></i>PayPal
                                </label>
                            </div>
                        </div>

                        <div class="border-top pt-3">
                            <div class="d-flex justify-content-between mb-2">
                                <span>Subtotal:</span>
                                <strong id="plan_price"></strong>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span>Tax (5%):</span>
                                <strong id="plan_tax"></strong>
                            </div>
                            <div class="d-flex justify-content-between border-top pt-2">
                                <strong>Total:</strong>
                                <strong id="plan_total" class="text-primary"></strong>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle me-2"></i>Confirm & Pay
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function selectPlan(planId, planName, planPrice) {
            document.getElementById('selected_plan_id').value = planId;
            document.getElementById('selected_plan_name').textContent = planName;

            const tax = planPrice * 0.05;
            const total = planPrice + tax;

            document.getElementById('plan_price').textContent = 'AED ' + planPrice.toFixed(2);
            document.getElementById('plan_tax').textContent = 'AED ' + tax.toFixed(2);
            document.getElementById('plan_total').textContent = 'AED ' + total.toFixed(2);
        }
    </script>
@endpush
