@extends('layouts.guest')
@section('title', __('Accept Invitation'))
@section('content')
{{--    display vaidation error--}}
@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
    <div class="container mx-auto px-4">
        <div class="max-w-md mx-auto bg-white p-6 rounded-lg shadow-md">
            <h2 class="text-2xl font-semibold mb-4">{{ __('Accept Invitation') }}</h2>
            <form method="POST" action="{{ route('business.team.accept-invitation', $invitation->id) }}">
                @csrf
                <div class="mb-4">
                    <label for="name" class="block text-gray-700">{{ __('First Name') }}</label>
                    <input type="text" id="first_name" name="first_name" value="{{ old('first_name', $invitation->user->first_name) }}" required
                           class="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring focus:border-blue-300">
                </div>
                <div class="mb-4">
                    <label for="name" class="block text-gray-700">{{ __('Last Name') }}</label>
                    <input type="text" id="last_name" name="last_name" value="{{ old('last_name') }}" required
                           class="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring focus:border-blue-300">
                </div>
                <div class="mb-4">
                    <label for="password" class="block text-gray-700">{{ __('Password') }}</label>
                    <input type="password" id="password" name="password" required
                           class="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring focus:border-blue-300">
                </div>
                <div class="mb-4">
                    <label for="password_confirmation" class="block text-gray-700">{{ __('Confirm Password') }}</label>
                    <input type="password" id="password_confirmation" name="password_confirmation" required
                           class="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring focus:border-blue-300">
                </div>
                <button type="submit"
                        class="w-full bg-blue-500 text-white py-2 px-4 rounded-lg hover:bg-blue-600 transition duration-200">
                    {{ __('Accept Invitation') }}
                </button>
            </form>
        </div>
    </div>
@endsection
