@extends('layouts.business')

@section('title', 'Add New Venue')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="fw-bold mb-1">Add New Venue</h2>
        <p class="text-muted mb-0">Create a new venue for your business</p>
    </div>
    <a href="{{ route('business.venues.index') }}" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left me-2"></i>Back to Venues
    </a>
</div>

<form action="{{ route('business.venues.store') }}" method="POST" enctype="multipart/form-data">
    @csrf

    <div class="row g-4">
        <!-- Basic Information -->
        <div class="col-lg-8">
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Basic Information</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Venue Name (English) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror"
                                   name="name" value="{{ old('name') }}" required>
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Venue Name (Arabic)</label>
                            <input type="text" class="form-control @error('name_ar') is-invalid @enderror"
                                   name="name_ar" value="{{ old('name_ar') }}" dir="rtl">
                            @error('name_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Category <span class="text-danger">*</span></label>
                            <select class="form-select @error('category_id') is-invalid @enderror" name="category_id" required>
                                <option value="">Select Category</option>
                                @foreach($categories ?? [] as $category)
                                    <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>
                                        {{ $category->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('category_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Phone <span class="text-danger">*</span></label>
                            <input type="tel" class="form-control @error('phone') is-invalid @enderror"
                                   name="phone" value="{{ old('phone') }}" required>
                            @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control @error('email') is-invalid @enderror"
                                   name="email" value="{{ old('email') }}">
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Website</label>
                            <input type="url" class="form-control @error('website') is-invalid @enderror"
                                   name="website" value="{{ old('website') }}" placeholder="https://example.com">
                            @error('website')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description (English)</label>
                            <textarea class="form-control @error('description') is-invalid @enderror"
                                      name="description" rows="4">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description (Arabic)</label>
                            <textarea class="form-control @error('description_ar') is-invalid @enderror"
                                      name="description_ar" rows="4" dir="rtl">{{ old('description_ar') }}</textarea>
                            @error('description_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <!-- Location Information -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Location Information</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-12">
                            <label class="form-label">Address (English) <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('address') is-invalid @enderror"
                                      name="address" rows="2" required>{{ old('address') }}</textarea>
                            @error('address')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label">Address (Arabic)</label>
                            <textarea class="form-control @error('address_ar') is-invalid @enderror"
                                      name="address_ar" rows="2" dir="rtl">{{ old('address_ar') }}</textarea>
                            @error('address_ar')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">City <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('city') is-invalid @enderror"
                                   name="city" value="{{ old('city') }}" required>
                            @error('city')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Area <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('area') is-invalid @enderror"
                                   name="area" value="{{ old('area') }}" required>
                            @error('area')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Latitude <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('latitude') is-invalid @enderror"
                                   name="latitude" value="{{ old('latitude') }}" placeholder="25.2048" required>
                            @error('latitude')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Longitude <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('longitude') is-invalid @enderror"
                                   name="longitude" value="{{ old('longitude') }}" placeholder="55.2708" required>
                            @error('longitude')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <div class="alert alert-info d-flex align-items-center">
                                <i class="bi bi-info-circle me-2"></i>
                                <small>You can get coordinates from Google Maps by right-clicking on the location</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Working Hours -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Working Hours</h5>
                </div>
                <div class="card-body">
                    @foreach(['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'] as $day)
                    <div class="row g-2 mb-3 align-items-center">
                        <div class="col-md-2">
                            <label class="form-label mb-0">{{ $day }}</label>
                        </div>
                        <div class="col-md-3">
                            <input type="time" class="form-control" name="working_hours[{{ strtolower($day) }}][open]"
                                   value="{{ old("working_hours.".strtolower($day).".open", '09:00') }}">
                        </div>
                        <div class="col-md-3">
                            <input type="time" class="form-control" name="working_hours[{{ strtolower($day) }}][close]"
                                   value="{{ old("working_hours.".strtolower($day).".close", '21:00') }}">
                        </div>
                        <div class="col-md-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="working_hours[{{ strtolower($day) }}][is_closed]"
                                       id="closed{{ $day }}" value="1">
                                <label class="form-check-label" for="closed{{ $day }}">Closed</label>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Images -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Images</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Featured Image</label>
                        <input type="file" class="form-control @error('featured_image') is-invalid @enderror"
                               name="featured_image" accept="image/*">
                        @error('featured_image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Main image for the venue</small>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Gallery Images</label>
                        <input type="file" class="form-control @error('images') is-invalid @enderror"
                               name="images[]" accept="image/*" multiple>
                        @error('images')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">You can select multiple images</small>
                    </div>
                </div>
            </div>

            <!-- Status & Settings -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Status & Settings</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="status">
                            <option value="active" selected>Active</option>
                            <option value="inactive">Inactive</option>
                            <option value="under_maintenance">Under Maintenance</option>
                        </select>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="is_featured" id="isFeatured" value="1">
                        <label class="form-check-label" for="isFeatured">
                            Featured Venue
                        </label>
                    </div>
                </div>
            </div>

            <!-- Amenities -->
            <div class="table-card mb-4">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Amenities</h5>
                </div>
                <div class="card-body">
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" name="amenities[]" value="parking" id="parking">
                        <label class="form-check-label" for="parking">Parking Available</label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" name="amenities[]" value="wifi" id="wifi">
                        <label class="form-check-label" for="wifi">Free WiFi</label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" name="amenities[]" value="wheelchair" id="wheelchair">
                        <label class="form-check-label" for="wheelchair">Wheelchair Accessible</label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" name="amenities[]" value="kids" id="kids">
                        <label class="form-check-label" for="kids">Kids Friendly</label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" name="amenities[]" value="outdoor" id="outdoor">
                        <label class="form-check-label" for="outdoor">Outdoor Seating</label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" name="amenities[]" value="ac" id="ac">
                        <label class="form-check-label" for="ac">Air Conditioned</label>
                    </div>
                </div>
            </div>

            <!-- Submit Buttons -->
            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-primary btn-lg">
                    <i class="bi bi-check-lg me-2"></i>Create Venue
                </button>
                <a href="{{ route('business.venues.index') }}" class="btn btn-outline-secondary">
                    Cancel
                </a>
            </div>
        </div>
    </div>
</form>
@endsection

@push('scripts')
<script>
    // Handle closed checkbox to disable time inputs
    document.querySelectorAll('[id^="closed"]').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const row = this.closest('.row');
            const timeInputs = row.querySelectorAll('input[type="time"]');
            timeInputs.forEach(input => {
                input.disabled = this.checked;
            });
        });
    });
</script>
@endpush
