@extends('layouts.guest')

@section('title', 'Premium Lifestyle Platform')

@push('styles')
    <style>
        .hero {
            background: linear-gradient(135deg, #8543ac 0%, #6b3589 100%);
            color: white;
            padding: 6rem 2rem;
            text-align: center;
            border-radius: 12px;
            margin-bottom: 4rem;
        }

        .hero h1 {
            font-size: 3.5rem;
            font-weight: 700;
            margin-bottom: 1.5rem;
            line-height: 1.2;
        }

        .hero p {
            font-size: 1.5rem;
            margin-bottom: 2.5rem;
            opacity: 0.95;
        }

        .hero-buttons {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
        }

        .hero-buttons .btn {
            padding: 1rem 2.5rem;
            font-size: 1.1rem;
        }

        .btn-white {
            background: white;
            color: #8543ac;
        }

        .btn-white:hover {
            background: #f8f9fa;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        .section {
            margin: 4rem 0;
        }

        .section h2 {
            text-align: center;
            font-size: 2.5rem;
            margin-bottom: 1rem;
            color: #2c3e50;
        }

        .section-subtitle {
            text-align: center;
            font-size: 1.2rem;
            color: #6c757d;
            margin-bottom: 3rem;
        }

        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin-bottom: 4rem;
        }

        .feature-card {
            background: white;
            padding: 2rem;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            transition: transform 0.3s, box-shadow 0.3s;
        }

        .feature-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 4px 16px rgba(133, 67, 172, 0.2);
        }

        .feature-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #8543ac 0%, #9d5fc0 100%);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1.5rem;
            color: white;
            font-size: 1.8rem;
        }

        .feature-card h3 {
            font-size: 1.5rem;
            margin-bottom: 1rem;
            color: #2c3e50;
        }

        .feature-card p {
            color: #6c757d;
            line-height: 1.8;
        }

        /* Pricing Cards */
        .pricing-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin-bottom: 4rem;
        }

        .pricing-card {
            background: white;
            border-radius: 12px;
            padding: 2.5rem 2rem;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            transition: transform 0.3s, box-shadow 0.3s;
            position: relative;
            display: flex;
            flex-direction: column;
        }

        .pricing-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 8px 24px rgba(133, 67, 172, 0.3);
        }

        .pricing-card.popular {
            border: 3px solid #8543ac;
            transform: scale(1.05);
        }

        .pricing-card.popular:hover {
            transform: scale(1.05) translateY(-8px);
        }

        .popular-badge {
            position: absolute;
            top: -12px;
            left: 50%;
            transform: translateX(-50%);
            background: linear-gradient(135deg, #8543ac 0%, #9d5fc0 100%);
            color: white;
            padding: 0.4rem 1.5rem;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 600;
            text-transform: uppercase;
        }

        .pricing-header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .plan-name {
            font-size: 1.8rem;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 0.5rem;
        }

        .plan-description {
            color: #6c757d;
            font-size: 0.95rem;
            margin-bottom: 1.5rem;
        }

        .plan-price {
            display: flex;
            align-items: baseline;
            justify-content: center;
            gap: 0.3rem;
            margin-bottom: 0.5rem;
        }

        .currency {
            font-size: 1.5rem;
            font-weight: 600;
            color: #8543ac;
        }

        .price {
            font-size: 3rem;
            font-weight: 700;
            color: #8543ac;
        }

        .period {
            font-size: 1rem;
            color: #6c757d;
        }

        .plan-duration {
            text-align: center;
            color: #6c757d;
            font-size: 0.9rem;
            margin-bottom: 2rem;
        }

        .plan-features {
            list-style: none;
            padding: 0;
            margin: 2rem 0;
            flex: 1;
        }

        .plan-features li {
            padding: 0.75rem 0;
            color: #2c3e50;
            display: flex;
            align-items: flex-start;
            gap: 0.75rem;
        }

        .plan-features li:before {
            content: "✓";
            color: #28a745;
            font-weight: bold;
            font-size: 1.2rem;
            flex-shrink: 0;
        }

        .plan-cta {
            margin-top: auto;
        }

        .plan-cta .btn {
            width: 100%;
            padding: 1rem;
            font-weight: 600;
        }

        .btn-plan-primary {
            background: linear-gradient(135deg, #8543ac 0%, #9d5fc0 100%);
            color: white;
        }

        .btn-plan-primary:hover {
            background: linear-gradient(135deg, #6b3589 0%, #8543ac 100%);
            transform: translateY(-2px);
        }

        .btn-plan-outline {
            border: 2px solid #8543ac;
            color: #8543ac;
            background: white;
        }

        .btn-plan-outline:hover {
            background: #8543ac;
            color: white;
        }

        .stats {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding: 4rem 2rem;
            border-radius: 12px;
            margin: 4rem 0;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 2rem;
            text-align: center;
        }

        .stat-item h3 {
            font-size: 3rem;
            color: #8543ac;
            margin-bottom: 0.5rem;
            font-weight: 700;
        }

        .stat-item p {
            color: #6c757d;
            font-size: 1.1rem;
        }

        .cta {
            background: white;
            padding: 4rem 2rem;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 4px 16px rgba(0,0,0,0.1);
            margin: 4rem 0;
        }

        .cta h2 {
            font-size: 2.5rem;
            margin-bottom: 1.5rem;
            color: #2c3e50;
        }

        .cta p {
            font-size: 1.2rem;
            color: #6c757d;
            margin-bottom: 2rem;
        }

        @media (max-width: 768px) {
            .hero h1 {
                font-size: 2.5rem;
            }

            .hero p {
                font-size: 1.2rem;
            }

            .section h2,
            .cta h2 {
                font-size: 2rem;
            }

            .features-grid,
            .pricing-grid {
                grid-template-columns: 1fr;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .pricing-card.popular {
                transform: scale(1);
            }

            .pricing-card.popular:hover {
                transform: translateY(-8px);
            }
        }
    </style>
@endpush

@section('content')
    <!-- Hero Section -->
    <div class="hero">
        <h1>Your Premium Lifestyle Platform</h1>
        <p>Unlock exclusive offers and experiences across UAE</p>
        <div class="hero-buttons">
            <a href="#pricing" class="btn btn-white">View Plans</a>
            <a href="#features" class="btn btn-outline">Learn More</a>
        </div>
    </div>

    <!-- Features Section -->
    <section id="features" class="section">
        <h2>Why Choose Privasee?</h2>
        <p class="section-subtitle">Everything you need to enjoy the best lifestyle experiences in UAE</p>
        <div class="features-grid">
            <div class="feature-card">
                <div class="feature-icon">🎯</div>
                <h3>Exclusive Offers</h3>
                <p>Access premium offers from the best venues across UAE. From restaurants to spas, entertainment to shopping - all in one place.</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">⚡</div>
                <h3>Instant Redemption</h3>
                <p>Redeem offers instantly with QR codes or manual codes. No waiting, no hassle - just show and save.</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">💎</div>
                <h3>VIP Experiences</h3>
                <p>Unlock exclusive deals and VIP experiences available only to premium members. Elevate your lifestyle.</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">📱</div>
                <h3>Easy to Use</h3>
                <p>Beautiful, intuitive mobile app with seamless navigation. Browse, save, and redeem offers in seconds.</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">🌟</div>
                <h3>Community Feed</h3>
                <p>Share your experiences through Spotlight. Connect with others, discover new places, and get inspired.</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">🔒</div>
                <h3>Secure & Private</h3>
                <p>Your data is protected with enterprise-grade security. GDPR compliant and privacy-first platform.</p>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats">
        <div class="stats-grid">
            <div class="stat-item">
                <h3>500+</h3>
                <p>Partner Venues</p>
            </div>
            <div class="stat-item">
                <h3>1000+</h3>
                <p>Exclusive Offers</p>
            </div>
            <div class="stat-item">
                <h3>50K+</h3>
                <p>Active Users</p>
            </div>
            <div class="stat-item">
                <h3>4.8★</h3>
                <p>User Rating</p>
            </div>
        </div>
    </section>

    <!-- User Pricing Section -->
    <section id="pricing" class="section">
        <h2>Choose Your Plan</h2>
        <p class="section-subtitle">Select the perfect plan for your lifestyle</p>
        <div class="pricing-grid">
            @foreach($userPlans as $plan)
                <div class="pricing-card {{ $plan->is_popular ? 'popular' : '' }}">
                    @if($plan->is_popular)
                        <div class="popular-badge">Most Popular</div>
                    @endif

                    <div class="pricing-header">
                        <h3 class="plan-name">{{ $plan->name }}</h3>
                        <p class="plan-description">{{ $plan->description }}</p>

                        <div class="plan-price">
                            <span class="currency">{{ $plan->currency }}</span>
                            <span class="price">{{ number_format($plan->price, 0) }}</span>
                            <span class="period">/month</span>
                        </div>
                        <p class="plan-duration">{{ $plan->duration }} days access</p>
                    </div>

                    <ul class="plan-features">
                        @php
                            $features = is_array($plan->features) ? $plan->features : json_decode($plan->features, true);
                        @endphp
                        @if($features && is_array($features))
                            @foreach($features as $feature)
                                <li>{{ $feature }}</li>
                            @endforeach
                        @endif
                    </ul>

                    <div class="plan-cta">
                        <a href="{{ route('register') }}" class="btn {{ $plan->is_popular ? 'btn-plan-primary' : 'btn-plan-outline' }}">
                            Get Started
                        </a>
                    </div>
                </div>
            @endforeach
        </div>
    </section>

    <!-- Business Pricing Section -->
    <section class="section">
        <h2>Business Plans</h2>
        <p class="section-subtitle">Grow your business with Privasee</p>
        <div class="pricing-grid">
            @foreach($businessPlans as $plan)
                <div class="pricing-card {{ $plan->is_popular ? 'popular' : '' }}">
                    @if($plan->is_popular)
                        <div class="popular-badge">Most Popular</div>
                    @endif

                    <div class="pricing-header">
                        <h3 class="plan-name">{{ $plan->name }}</h3>
                        <p class="plan-description">{{ $plan->description }}</p>

                        <div class="plan-price">
                            <span class="currency">{{ $plan->currency }}</span>
                            <span class="price">{{ number_format($plan->price, 0) }}</span>
                            <span class="period">/month</span>
                        </div>
                        <p class="plan-duration">{{ $plan->duration }} days access</p>
                    </div>

                    <ul class="plan-features">
                        @php
                            $features = is_array($plan->features) ? $plan->features : json_decode($plan->features, true);
                        @endphp
                        @if($features && is_array($features))
                            @foreach($features as $feature)
                                <li>{{ $feature }}</li>
                            @endforeach
                        @endif

                        @if($plan->max_venues)
                            <li><strong>{{ $plan->max_venues }}</strong> {{ $plan->max_venues == 1 ? 'Venue' : 'Venues' }}</li>
                        @endif

                        @if($plan->max_offers_per_venue)
                            <li><strong>{{ $plan->max_offers_per_venue }}</strong> Offers per Venue</li>
                        @endif

                        @if($plan->max_team_members)
                            <li><strong>{{ $plan->max_team_members }}</strong> Team Members</li>
                        @endif
                    </ul>

                    <div class="plan-cta">
                        <a href="{{ url('/business/register') }}" class="btn {{ $plan->is_popular ? 'btn-plan-primary' : 'btn-plan-outline' }}">
                            Get Started
                        </a>
                    </div>
                </div>
            @endforeach
        </div>
    </section>

    <!-- How It Works Section -->
    <section id="about" class="section">
        <h2>How It Works</h2>
        <p class="section-subtitle">Start saving in three simple steps</p>
        <div class="features-grid">
            <div class="feature-card">
                <div class="feature-icon">1️⃣</div>
                <h3>Sign Up</h3>
                <p>Create your free account in seconds. Choose from Basic, Premium, or VIP membership plans.</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">2️⃣</div>
                <h3>Browse Offers</h3>
                <p>Discover exclusive offers from hundreds of partner venues across all Emirates.</p>
            </div>

            <div class="feature-card">
                <div class="feature-icon">3️⃣</div>
                <h3>Redeem & Enjoy</h3>
                <p>Show your QR code or redemption code at the venue and enjoy amazing savings!</p>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section id="contact" class="cta">
        <h2>Ready to Start Saving?</h2>
        <p>Join thousands of UAE residents enjoying exclusive lifestyle offers</p>
        <div class="hero-buttons">
            <a href="{{ route('register') }}" class="btn btn-primary">Start Your Free Trial</a>
            <a href="mailto:support@privasee.com" class="btn btn-outline">Contact Sales</a>
        </div>
    </section>
@endsection
