<?php $__env->startSection('title', 'Subscription Plans'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid py-4">
        <!-- Header -->
        <div class="row mb-4">
            <div class="col">
                <h2 class="mb-3">Subscription Plans Management</h2>
                <p class="text-muted">Manage subscription plans for businesses and end users</p>
            </div>
            <div class="col-auto">
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createPlanModal">
                    <i class="bi bi-plus-circle me-2"></i>Create New Plan
                </button>
            </div>
        </div>

        <!-- Plan Type Tabs -->
        <ul class="nav nav-tabs mb-4">
            <li class="nav-item">
                <a class="nav-link <?php echo e($type === 'business' ? 'active' : ''); ?>" href="<?php echo e(route('admin.subscription-plans.index', ['type' => 'business'])); ?>">
                    <i class="bi bi-building me-2"></i>Business Plans
                    <span class="badge bg-primary ms-2"><?php echo e($businessPlansCount); ?></span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo e($type === 'user' ? 'active' : ''); ?>" href="<?php echo e(route('admin.subscription-plans.index', ['type' => 'user'])); ?>">
                    <i class="bi bi-person me-2"></i>User Plans
                    <span class="badge bg-info ms-2"><?php echo e($userPlansCount); ?></span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo e($type === 'marketing' ? 'active' : ''); ?>" href="<?php echo e(route('admin.subscription-plans.index', ['type' => 'marketing'])); ?>">
                    <i class="bi bi-megaphone me-2"></i>Marketing Plans
                    <span class="badge bg-success ms-2"><?php echo e($marketingPlansCount ?? 0); ?></span>
                </a>
            </li>
        </ul>

        <!-- Plan Type Info Alert -->
        <div class="alert alert-info mb-4">
            <i class="bi bi-info-circle me-2"></i>
            <?php if($type === 'business'): ?>
                <strong>Business Plans:</strong> Subscription plans for businesses using the platform to manage venues and offers.
            <?php elseif($type === 'marketing'): ?>
                <strong>Marketing Plans:</strong> Subscription plans for businesses to access promotional and marketing features.
            <?php else: ?>
                <strong>User Plans:</strong> Subscription plans for end-users of the mobile/web application.
            <?php endif; ?>
        </div>

        <!-- Stats Cards -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="text-muted mb-1">Total Plans</p>
                                <h3 class="mb-0"><?php echo e($stats['total_plans']); ?></h3>
                            </div>
                            <div class="bg-primary bg-opacity-10 rounded p-3">
                                <i class="bi bi-card-checklist text-primary fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="text-muted mb-1">Active Plans</p>
                                <h3 class="mb-0"><?php echo e($stats['active_plans']); ?></h3>
                            </div>
                            <div class="bg-success bg-opacity-10 rounded p-3">
                                <i class="bi bi-check-circle-fill text-success fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="text-muted mb-1">Total Subscriptions</p>
                                <h3 class="mb-0"><?php echo e(number_format($stats['total_subscriptions'])); ?></h3>
                            </div>
                            <div class="bg-info bg-opacity-10 rounded p-3">
                                <i class="bi bi-people-fill text-info fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="text-muted mb-1">Monthly Revenue</p>
                                <h3 class="mb-0">AED <?php echo e(number_format($stats['monthly_revenue'], 2)); ?></h3>
                            </div>
                            <div class="bg-warning bg-opacity-10 rounded p-3">
                                <i class="bi bi-currency-dollar text-warning fs-4"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Plans Grid -->
        <div class="row">
            <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-md-4 mb-4">
                    <div class="card h-100 <?php echo e($plan->is_popular ? 'border-primary' : ''); ?>" style="position: relative;">
                        <?php if($plan->is_popular): ?>
                            <div class="position-absolute top-0 end-0 m-2">
                    <span class="badge bg-primary">
                        <i class="bi bi-star-fill me-1"></i>Popular
                    </span>
                            </div>
                        <?php endif; ?>

                        <?php if(!$plan->is_active): ?>
                            <div class="position-absolute top-0 start-0 m-2">
                                <span class="badge bg-secondary">Inactive</span>
                            </div>
                        <?php endif; ?>

                        <div class="card-body d-flex flex-column">
                            <div class="text-center mb-4">
                                <h4 class="mb-2"><?php echo e($plan->name); ?></h4>
                                <?php if($plan->name_ar): ?>
                                    <p class="text-muted mb-3" dir="rtl"><?php echo e($plan->name_ar); ?></p>
                                <?php endif; ?>
                                <div class="display-4 fw-bold text-primary">
                                    AED <?php echo e(number_format($plan->price, 0)); ?>

                                </div>
                                <p class="text-muted">
                                    per <?php echo e($plan->duration_type); ?>

                                    <?php if($plan->duration_type === 'custom'): ?>
                                        (<?php echo e($plan->duration_days); ?> days)
                                    <?php endif; ?>
                                </p>
                            </div>

                            <div class="mb-4">
                                <?php if($plan->description): ?>
                                    <p class="text-muted small"><?php echo e($plan->description); ?></p>
                                <?php endif; ?>
                            </div>

                            <!-- Features -->
                            <div class="mb-4 flex-grow-1">
                                <h6 class="mb-3">Features:</h6>
                                <?php $features = json_decode($plan->features, true); ?>
                                <?php if($features): ?>
                                    <ul class="list-unstyled">
                                        <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="mb-2">
                                                <i class="bi bi-check-circle-fill text-success me-2"></i>
                                                <?php echo e($feature); ?>

                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php endif; ?>
                            </div>

                            <!-- Limits -->
                            <div class="mb-4 p-3 bg-light rounded">
                                <small class="text-muted d-block mb-2"><strong>Limits:</strong></small>
                                <div class="row g-2 small">
                                    <?php if($plan->max_venues): ?>
                                        <div class="col-6">
                                            <i class="bi bi-building me-1"></i><?php echo e($plan->max_venues); ?> venues
                                        </div>
                                    <?php endif; ?>
                                    <?php if($plan->max_offers): ?>
                                        <div class="col-6">
                                            <i class="bi bi-tag me-1"></i><?php echo e($plan->max_offers); ?> offers
                                        </div>
                                    <?php endif; ?>
                                    <?php if($plan->max_staff): ?>
                                        <div class="col-6">
                                            <i class="bi bi-people me-1"></i><?php echo e($plan->max_staff); ?> staff
                                        </div>
                                    <?php endif; ?>
                                    <?php if($plan->max_photos_per_venue): ?>
                                        <div class="col-6">
                                            <i class="bi bi-image me-1"></i><?php echo e($plan->max_photos_per_venue); ?> photos
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Extras -->
                            <div class="mb-4">
                                <?php if($plan->analytics_access): ?>
                                    <span class="badge bg-info me-1 mb-1">Analytics</span>
                                <?php endif; ?>
                                <?php if($plan->priority_support): ?>
                                    <span class="badge bg-success me-1 mb-1">Priority Support</span>
                                <?php endif; ?>
                                <?php if($plan->featured_listing): ?>
                                    <span class="badge bg-warning me-1 mb-1">Featured</span>
                                <?php endif; ?>
                                <?php if($plan->custom_branding): ?>
                                    <span class="badge bg-primary me-1 mb-1">Custom Branding</span>
                                <?php endif; ?>
                                <?php if($plan->api_access): ?>
                                    <span class="badge bg-dark me-1 mb-1">API Access</span>
                                <?php endif; ?>
                            </div>

                            <!-- Stats -->
                            <div class="mb-3 p-2 bg-light rounded text-center">
                                <small class="text-muted">
                                    <strong><?php echo e($plan->subscriptions_count); ?></strong> total subscribers
                                    <span class="mx-2">|</span>
                                    <strong><?php echo e($plan->active_subscriptions_count); ?></strong> active
                                </small>
                            </div>

                            <!-- Actions -->
                            <div class="d-grid gap-2">
                                <div class="btn-group">
                                    <button onclick="editPlan(<?php echo e($plan->id); ?>)" class="btn btn-sm btn-primary">
                                        <i class="bi bi-pencil me-1"></i>Edit
                                    </button>
                                    <a href="<?php echo e(route('admin.subscription-plans.subscribers', $plan->id)); ?>" class="btn btn-sm btn-info">
                                        <i class="bi bi-people me-1"></i>Subscribers
                                    </a>
                                    <button onclick="toggleStatus(<?php echo e($plan->id); ?>)" class="btn btn-sm btn-outline-<?php echo e($plan->is_active ? 'danger' : 'success'); ?>">
                                        <i class="bi bi-<?php echo e($plan->is_active ? 'toggle-on' : 'toggle-off'); ?>"></i>
                                    </button>
                                    <button onclick="togglePopular(<?php echo e($plan->id); ?>)" class="btn btn-sm btn-outline-warning">
                                        <i class="bi bi-star<?php echo e($plan->is_popular ? '-fill' : ''); ?>"></i>
                                    </button>
                                    <button onclick="deletePlan(<?php echo e($plan->id); ?>)" class="btn btn-sm btn-outline-danger">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12">
                    <div class="card">
                        <div class="card-body text-center py-5">
                            <i class="bi bi-card-checklist text-muted" style="font-size: 64px;"></i>
                            <p class="text-muted mt-3 mb-3">No subscription plans found</p>
                            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createPlanModal">
                                <i class="bi bi-plus-circle me-2"></i>Create First Plan
                            </button>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Create Plan Modal -->
    <div class="modal fade" id="createPlanModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Create Subscription Plan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form id="createPlanForm">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Plan Name (English) <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Plan Name (Arabic)</label>
                                <input type="text" class="form-control" name="name_ar" dir="rtl">
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (English)</label>
                                <textarea class="form-control" name="description" rows="2"></textarea>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (Arabic)</label>
                                <textarea class="form-control" name="description_ar" rows="2" dir="rtl"></textarea>
                            </div>

                            <div class="col-md-12">
                                <label class="form-label">Plan Type <span class="text-danger">*</span></label>
                                <select class="form-select" name="type" required>
                                    <option value="business" <?php echo e($type === 'business' ? 'selected' : ''); ?>>Business Plan</option>
                                    <option value="user" <?php echo e($type === 'user' ? 'selected' : ''); ?>>User Plan</option>
                                    <option value="marketing" <?php echo e($type === 'marketing' ? 'selected' : ''); ?>>Marketing Plan</option>
                                </select>
                                <small class="text-muted">
                                    Business plans for venue management, User plans for app users, Marketing plans for promotional campaigns.
                                </small>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Price (AED) <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" name="price" step="0.01" min="0" required>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Duration Type <span class="text-danger">*</span></label>
                                <select class="form-select" name="duration_type" required>
                                    <option value="monthly">Monthly</option>
                                    <option value="yearly">Yearly</option>
                                    <option value="custom">Custom</option>
                                </select>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Duration Days <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" name="duration_days" value="30" min="1" required>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Features <span class="text-danger">*</span></label>
                                <div id="featuresContainer">
                                    <div class="input-group mb-2">
                                        <input type="text" class="form-control" name="features[]" placeholder="Enter feature">
                                        <button type="button" class="btn btn-success" onclick="addFeature()">
                                            <i class="bi bi-plus"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Max Venues</label>
                                <input type="number" class="form-control" name="max_venues" min="1">
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Max Offers</label>
                                <input type="number" class="form-control" name="max_offers" min="1">
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Max Staff</label>
                                <input type="number" class="form-control" name="max_staff" min="1">
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Max Photos</label>
                                <input type="number" class="form-control" name="max_photos_per_venue" min="1">
                            </div>

                            <div class="col-12">
                                <label class="form-label">Extra Features</label>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="analytics_access" value="1" id="analytics">
                                            <label class="form-check-label" for="analytics">Analytics Access</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="priority_support" value="1" id="support">
                                            <label class="form-check-label" for="support">Priority Support</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="featured_listing" value="1" id="featured">
                                            <label class="form-check-label" for="featured">Featured Listing</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="custom_branding" value="1" id="branding">
                                            <label class="form-check-label" for="branding">Custom Branding</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="api_access" value="1" id="api">
                                            <label class="form-check-label" for="api">API Access</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="is_popular" value="1" id="popular">
                                            <label class="form-check-label" for="popular">Mark as Popular</label>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Sort Order</label>
                                <input type="number" class="form-control" name="sort_order" value="0">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Status</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="is_active" value="1" id="active" checked>
                                    <label class="form-check-label" for="active">Active</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Create Plan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Edit Plan Modal -->
    <div class="modal fade" id="editPlanModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Subscription Plan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <form id="editPlanForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" id="edit_id">

                    <div class="modal-body">
                        <div class="row g-3">

                            <div class="col-md-6">
                                <label class="form-label">Plan Name (English)</label>
                                <input type="text" class="form-control" name="name" id="edit_name" required>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Plan Name (Arabic)</label>
                                <input type="text" class="form-control" name="name_ar" id="edit_name_ar" dir="rtl">
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (English)</label>
                                <textarea class="form-control" name="description" id="edit_description"></textarea>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Description (Arabic)</label>
                                <textarea class="form-control" name="description_ar" id="edit_description_ar" dir="rtl"></textarea>
                            </div>

                            <div class="col-md-12">
                                <label class="form-label">Plan Type</label>
                                <select class="form-select" name="type" id="edit_type">
                                    <option value="business">Business Plan</option>
                                    <option value="user">User Plan</option>
                                    <option value="marketing">Marketing Plan</option>
                                </select>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Price (AED)</label>
                                <input type="number" class="form-control" name="price" id="edit_price" step="0.01">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Duration Type</label>
                                <select class="form-select" name="duration_type" id="edit_duration_type">
                                    <option value="monthly">Monthly</option>
                                    <option value="yearly">Yearly</option>
                                    <option value="custom">Custom</option>
                                </select>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Duration Days</label>
                                <input type="number" class="form-control" name="duration_days" id="edit_duration_days">
                            </div>

                            <!-- Features -->
                            <div class="col-12">
                                <label class="form-label">Features</label>
                                <div id="editFeaturesContainer"></div>
                                <button type="button" class="btn btn-success mt-2" onclick="addEditFeature()">
                                    <i class="bi bi-plus"></i> Add Feature
                                </button>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Max Venues</label>
                                <input type="number" class="form-control" id="edit_max_venues" name="max_venues">
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Max Offers</label>
                                <input type="number" class="form-control" id="edit_max_offers" name="max_offers">
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Max Staff</label>
                                <input type="number" class="form-control" id="edit_max_staff" name="max_staff">
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">Max Photos</label>
                                <input type="number" class="form-control" id="edit_max_photos_per_venue" name="max_photos_per_venue">
                            </div>

                            <!-- Extra Features -->
                            <div class="col-12">
                                <label class="form-label">Extra Features</label>
                                <div class="row">

                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="edit_analytics_access" name="analytics_access" value="1">
                                            <label class="form-check-label">Analytics Access</label>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="edit_priority_support" name="priority_support" value="1">
                                            <label class="form-check-label">Priority Support</label>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="edit_featured_listing" name="featured_listing" value="1">
                                            <label class="form-check-label">Featured Listing</label>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="edit_custom_branding" name="custom_branding" value="1">
                                            <label class="form-check-label">Custom Branding</label>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="edit_api_access" name="api_access" value="1">
                                            <label class="form-check-label">API Access</label>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="edit_is_popular" name="is_popular" value="1">
                                            <label class="form-check-label">Mark as Popular</label>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Sort Order</label>
                                <input type="number" class="form-control" name="sort_order" id="edit_sort_order">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Status</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" name="is_active" value="1" id="edit_is_active">
                                    <label class="form-check-label">Active</label>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Update Plan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function addFeature() {
            const container = document.getElementById('featuresContainer');
            const div = document.createElement('div');
            div.className = 'input-group mb-2';
            div.innerHTML = `
        <input type="text" class="form-control" name="features[]" placeholder="Enter feature">
        <button type="button" class="btn btn-danger" onclick="this.parentElement.remove()">
            <i class="bi bi-dash"></i>
        </button>
    `;
            container.appendChild(div);
        }

        document.getElementById('createPlanForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = new FormData(this);
            const data = {};

            formData.forEach((value, key) => {
                if (key === 'features[]') {
                    if (!data.features) data.features = [];
                    if (value.trim()) data.features.push(value);
                } else if (key.includes('[')) {
                    return;
                } else {
                    data[key] = value;
                }
            });

            fetch('<?php echo e(route('admin.subscription-plans.store')); ?>', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(data)
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                });
        });

        function toggleStatus(id) {
            fetch(`/admin/subscription-plans/${id}/toggle`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                });
        }

        function togglePopular(id) {
            fetch(`/admin/subscription-plans/${id}/toggle-popular`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                }
            })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                });
        }

        function deletePlan(id) {
            if (confirm('Are you sure you want to delete this plan?')) {
                fetch(`/admin/subscription-plans/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    }
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            location.reload();
                        } else {
                            alert(data.message);
                        }
                    });
            }
        }
        function editPlan(id) {
            fetch(`/admin/subscription-plans/${id}/edit`)
                .then(res => res.json())
                .then(plan => {
                    console.log(plan);
                    // Basic fields
                    document.getElementById('edit_id').value = plan.plan.id;
                    document.getElementById('edit_name').value = plan.plan.name;
                    document.getElementById('edit_name_ar').value = plan.plan.name_ar ?? '';
                    document.getElementById('edit_description').value = plan.plan.description ?? '';
                    document.getElementById('edit_description_ar').value = plan.plan.description_ar ?? '';
                    document.getElementById('edit_type').value = plan.plan.type;
                    document.getElementById('edit_price').value = plan.plan.price;
                    document.getElementById('edit_duration_type').value = plan.plan.duration_type;
                    document.getElementById('edit_duration_days').value = plan.plan.duration_days;

                    // Limits
                    document.getElementById('edit_max_venues').value = plan.plan.max_venues ?? '';
                    document.getElementById('edit_max_offers').value = plan.plan.max_offers ?? '';
                    document.getElementById('edit_max_staff').value = plan.plan.max_staff ?? '';
                    document.getElementById('edit_max_photos_per_venue').value = plan.plan.max_photos_per_venue ?? '';

                    // Extra features
                    document.getElementById('edit_analytics_access').checked = plan.plan.analytics_access == 1;
                    document.getElementById('edit_priority_support').checked = plan.plan.priority_support == 1;
                    document.getElementById('edit_featured_listing').checked = plan.plan.featured_listing == 1;
                    document.getElementById('edit_custom_branding').checked = plan.plan.custom_branding == 1;
                    document.getElementById('edit_api_access').checked = plan.plan.api_access == 1;
                    document.getElementById('edit_is_popular').checked = plan.plan.is_popular == 1;
                    document.getElementById('edit_is_active').checked = plan.plan.is_active == 1;

                    // Handle Features
                    const container = document.getElementById('editFeaturesContainer');
                    container.innerHTML = '';

                    let features = JSON.parse(plan.plan.features ?? '[]');

                    features.forEach(f => {
                        container.innerHTML += `
                    <div class="input-group mb-2">
                        <input type="text" class="form-control" name="features[]" value="${f}">
                        <button class="btn btn-danger" type="button" onclick="this.parentElement.remove()">
                            <i class="bi bi-dash"></i>
                        </button>
                    </div>`;
                    });

                    new bootstrap.Modal(document.getElementById('editPlanModal')).show();
                });
        }
        function addEditFeature() {
            const container = document.getElementById('editFeaturesContainer');
            container.innerHTML += `
        <div class="input-group mb-2">
            <input type="text" class="form-control" name="features[]" placeholder="Enter feature">
            <button class="btn btn-danger" type="button" onclick="this.parentElement.remove()">
                <i class="bi bi-dash"></i>
            </button>
        </div>`;
        }
        document.getElementById('editPlanForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const formData = new FormData(this);
            const id = document.getElementById('edit_id').value;

            const data = {};
            formData.forEach((value, key) => {
                if (key === 'features[]') {
                    if (!data.features) data.features = [];
                    if (value.trim()) data.features.push(value);
                } else {
                    data[key] = value;
                }
            });

            fetch(`/admin/subscription-plans/${id}`, {
                method: 'PUT',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(data)
            })
                .then(res => res.json())
                .then(res => {
                    if (res.success) location.reload();
                });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/admin/subscription-plans/index.blade.php ENDPATH**/ ?>