<?php $__env->startSection('title', 'Team Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Team Management</h2>
            <p class="text-muted mb-0">Manage your team members, roles and permissions</p>
        </div>
        <?php if(!isset($requires_subscription) && !isset($no_permission)): ?>
            <div class="d-flex gap-2">
                <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#manageRolesModal">
                    <i class="bi bi-shield-check me-2"></i>View Roles
                </button>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#inviteModal">
                    <i class="bi bi-person-plus me-2"></i>Invite Team Member
                </button>
            </div>
        <?php endif; ?>
    </div>

    <?php if(isset($requires_subscription) && $requires_subscription): ?>
        <!-- Subscription Required Alert -->
        <div class="alert alert-warning border-0 shadow-sm mb-4">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h5 class="alert-heading mb-2">
                        <i class="bi bi-lock-fill me-2"></i>Subscription Required
                    </h5>
                    <p class="mb-0">
                        Team management is a premium feature. Subscribe to a plan to invite and manage team members.
                    </p>
                </div>
                <div class="col-md-4 text-end">
                    <a href="<?php echo e(route('business.subscription.plans')); ?>" class="btn btn-warning">
                        <i class="bi bi-star-fill me-2"></i>View Plans
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if(isset($no_permission) && $no_permission): ?>
        <!-- No Permission Alert -->
        <div class="alert alert-danger border-0 shadow-sm mb-4">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <h5 class="alert-heading mb-2">
                        <i class="bi bi-shield-x me-2"></i>Access Denied
                    </h5>
                    <p class="mb-0">
                        You do not have permission to manage team members. Please contact your business administrator.
                    </p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Stats Cards -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                    <i class="bi bi-people text-white"></i>
                </div>
                <div class="stat-label">Total Members</div>
                <div class="stat-value"><?php echo e($stats['total_staff'] ?? 0); ?></div>
                <small class="text-muted"><?php echo e($stats['active_staff'] ?? 0); ?> active</small>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                    <i class="bi bi-person-badge text-white"></i>
                </div>
                <div class="stat-label">Managers</div>
                <div class="stat-value"><?php echo e($stats['managers'] ?? 0); ?></div>
                <small class="text-muted">Full access</small>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                    <i class="bi bi-person text-white"></i>
                </div>
                <div class="stat-label">Staff Members</div>
                <div class="stat-value"><?php echo e($stats['staff_members'] ?? 0); ?></div>
                <small class="text-muted">Limited access</small>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);">
                    <i class="bi bi-envelope text-white"></i>
                </div>
                <div class="stat-label">Pending Invites</div>
                <div class="stat-value"><?php echo e($stats['pending_invitations'] ?? 0); ?></div>
                <small class="text-muted">Awaiting response</small>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="table-card mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <input type="text" class="form-control" name="search" placeholder="Search by name or email" value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <select class="form-select" name="role">
                        <option value="">All Roles</option>
                        <option value="manager" <?php echo e(request('role') === 'manager' ? 'selected' : ''); ?>>Managers</option>
                        <option value="staff" <?php echo e(request('role') === 'staff' ? 'selected' : ''); ?>>Staff</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select class="form-select" name="status">
                        <option value="">All Status</option>
                        <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="pending_invitation" <?php echo e(request('status') === 'pending_invitation' ? 'selected' : ''); ?>>Pending</option>
                        <option value="inactive" <?php echo e(request('status') === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                    </select>
                </div>
                <div class="col-md-5">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-search me-2"></i>Filter
                    </button>
                    <a href="<?php echo e(route('business.team.index')); ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-x-lg me-2"></i>Clear
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Team Members Table -->
    <div class="table-card">
        <div class="card-header">
            <h5 class="mb-0 fw-bold">Team Members</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                    <tr>
                        <th>Member</th>
                        <th>Role</th>
                        <th>Permissions</th>
                        <th>Status</th>
                        <th>Joined Date</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center gap-3">
                                    <img src="https://ui-avatars.com/api/?name=<?php echo e($member->user->full_name); ?>&background=random"
                                         class="rounded-circle" width="40" height="40">
                                    <div>
                                        <div class="fw-semibold"><?php echo e($member->user->full_name); ?></div>
                                        <small class="text-muted"><?php echo e($member->user->email); ?></small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <?php if($member->role === 'owner'): ?>
                                    <span class="badge bg-gradient" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                    <i class="bi bi-crown me-1"></i>Owner
                                </span>
                                <?php elseif($member->role === 'manager'): ?>
                                    <span class="badge bg-primary">
                                    <i class="bi bi-person-badge me-1"></i>Manager
                                </span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">
                                    <i class="bi bi-person me-1"></i>Staff
                                </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($member->role === 'owner'): ?>
                                    <small class="text-muted">Full Access</small>
                                <?php else: ?>
                                    <div class="d-flex flex-wrap gap-1">
                                        <?php $__currentLoopData = $member->permissions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge bg-light text-dark"><?php echo e(str_replace('_', ' ', ucfirst($permission))); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($member->status === 'active'): ?>
                                    <span class="badge bg-success">
                                    <i class="bi bi-check-circle me-1"></i>Active
                                </span>
                                <?php elseif($member->status === 'pending_invitation'): ?>
                                    <span class="badge bg-warning">
                                    <i class="bi bi-clock me-1"></i>Pending
                                </span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">
                                    <i class="bi bi-dash-circle me-1"></i>Inactive
                                </span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($member->joined_at): ?>
                                    <span><?php echo e($member->joined_at->format('M d, Y')); ?></span>
                                    <br><small class="text-muted"><?php echo e($member->joined_at->diffForHumans()); ?></small>
                                <?php else: ?>
                                    <span class="text-muted">Not joined</span>
                                    <br><small>Invited <?php echo e($member->invited_at->diffForHumans()); ?></small>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <?php if($member->role !== 'owner'): ?>
                                        <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($member->id); ?>">
                                            <i class="bi bi-pencil"></i>
                                        </button>
                                        <?php if($member->status === 'pending_invitation'): ?>
                                            <form action="<?php echo e(route('business.team.resend-invitation', $member->id)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-sm btn-outline-info" title="Resend Invitation">
                                                    <i class="bi bi-send"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                        <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($member->id); ?>">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    <?php else: ?>
                                        <span class="text-muted small">Owner</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <!-- Edit Modal -->
                        <div class="modal fade" id="editModal<?php echo e($member->id); ?>" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <form action="<?php echo e(route('business.team.update', $member->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>
                                        <div class="modal-header">
                                            <h5 class="modal-title">Edit Team Member</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="mb-3">
                                                <label class="form-label">Role</label>
                                                <select class="form-select" name="role" required>
                                                    <option value="manager" <?php echo e($member->role === 'manager' ? 'selected' : ''); ?>>Manager</option>
                                                    <option value="staff" <?php echo e($member->role === 'staff' ? 'selected' : ''); ?>>Staff</option>
                                                </select>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Permissions</label>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_venues" id="perm1_<?php echo e($member->id); ?>"
                                                        <?php echo e(in_array('manage_venues', $member->permissions ?? []) ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="perm1_<?php echo e($member->id); ?>">Manage Venues</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_offers" id="perm2_<?php echo e($member->id); ?>"
                                                        <?php echo e(in_array('manage_offers', $member->permissions ?? []) ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="perm2_<?php echo e($member->id); ?>">Manage Offers</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_staff" id="perm3_<?php echo e($member->id); ?>"
                                                        <?php echo e(in_array('manage_staff', $member->permissions ?? []) ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="perm3_<?php echo e($member->id); ?>">Manage Staff</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="view_analytics" id="perm4_<?php echo e($member->id); ?>"
                                                        <?php echo e(in_array('view_analytics', $member->permissions ?? []) ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="perm4_<?php echo e($member->id); ?>">View Analytics</label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="redeem_offers" id="perm5_<?php echo e($member->id); ?>"
                                                        <?php echo e(in_array('redeem_offers', $member->permissions ?? []) ? 'checked' : ''); ?>>
                                                    <label class="form-check-label" for="perm5_<?php echo e($member->id); ?>">Redeem Offers</label>
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Status</label>
                                                <select class="form-select" name="status">
                                                    <option value="active" <?php echo e($member->status === 'active' ? 'selected' : ''); ?>>Active</option>
                                                    <option value="inactive" <?php echo e($member->status === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                            <button type="submit" class="btn btn-primary">Save Changes</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Delete Modal -->
                        <div class="modal fade" id="deleteModal<?php echo e($member->id); ?>" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header border-0">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body text-center py-4">
                                        <div class="mb-3">
                                            <i class="bi bi-exclamation-triangle text-danger" style="font-size: 4rem;"></i>
                                        </div>
                                        <h5>Remove Team Member?</h5>
                                        <p class="text-muted">Are you sure you want to remove <strong><?php echo e($member->user->full_name); ?></strong> from your team?</p>
                                    </div>
                                    <div class="modal-footer border-0 justify-content-center">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                        <form action="<?php echo e(route('business.team.destroy', $member->id)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger">Yes, Remove</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-5">
                                <i class="bi bi-people fs-1 text-muted d-block mb-3"></i>
                                <p class="text-muted mb-0">No team members found</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>





    </div>

    <!-- Invite Modal -->
    <div class="modal fade" id="inviteModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="<?php echo e(route('business.team.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title">Invite Team Member</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Email Address</label>
                            <input type="email" class="form-control" name="email" required placeholder="member@example.com">
                            <small class="text-muted">An invitation will be sent to this email</small>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Role</label>
                            <select class="form-select" name="role" id="roleSelect" required onchange="toggleCustomPermissions()">
                                <optgroup label="System Roles">
                                    <option value="manager">Manager - Full management access</option>
                                    <option value="staff">Staff - Custom permissions</option>
                                </optgroup>
                                <?php if(isset($customRoles) && count($customRoles) > 0): ?>
                                    <optgroup label="Custom Roles">
                                        <?php $__currentLoopData = $customRoles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="custom_<?php echo e($role->id); ?>"><?php echo e($role->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </optgroup>
                                <?php endif; ?>
                            </select>




                        </div>
                        <div class="mb-3" id="customPermissionsSection">
                            <label class="form-label">Custom Permissions</label>
                            <div class="alert alert-info small mb-2">
                                <i class="bi bi-info-circle me-1"></i>
                                Only shown when "Staff" role is selected. Custom roles have predefined permissions.
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_venues" id="newPerm1">
                                <label class="form-check-label" for="newPerm1">Manage Venues</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_offers" id="newPerm2">
                                <label class="form-check-label" for="newPerm2">Manage Offers</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_staff" id="newPerm3">
                                <label class="form-check-label" for="newPerm3">Manage Staff</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="permissions[]" value="view_analytics" id="newPerm4">
                                <label class="form-check-label" for="newPerm4">View Analytics</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="permissions[]" value="redeem_offers" id="newPerm5" checked>
                                <label class="form-check-label" for="newPerm5">Redeem Offers</label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-send me-2"></i>Send Invitation
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Manage Roles Modal -->
    <div class="modal fade" id="manageRolesModal" tabindex="-1">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Manage Custom Roles</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">







                    <!-- Create Role Form (Hidden by default) -->

































































































































































































                    <!-- Existing Roles List -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                            <tr>
                                <th>Role Name</th>
                                <th>Description</th>
                                <th>Permissions</th>
                                <th>Members</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <!-- System Roles (Cannot be edited) -->
                            <tr class="table-light">
                                <td>
                                    <span class="badge" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                                        <i class="bi bi-crown me-1"></i>Owner
                                    </span>
                                </td>
                                <td>Business owner with full access</td>
                                <td><span class="badge bg-success">All Permissions</span></td>
                                <td>1</td>
                                <td><span class="text-muted small">System Role</span></td>
                            </tr>
                            <tr class="table-light">
                                <td><span class="badge bg-primary">Manager</span></td>
                                <td>Full management access</td>
                                <td><span class="badge bg-success">All Permissions</span></td>
                                <td><?php echo e($stats['managers'] ?? 0); ?></td>
                                <td><span class="text-muted small">System Role</span></td>
                            </tr>
                            <tr class="table-light">
                                <td><span class="badge bg-secondary">Staff</span></td>
                                <td>Basic staff member</td>
                                <td><span class="badge bg-info">Custom Permissions</span></td>
                                <td><?php echo e($stats['staff_members'] ?? 0); ?></td>
                                <td><span class="text-muted small">System Role</span></td>
                            </tr>

                            <!-- Custom Roles -->
                            <?php $__empty_1 = true; $__currentLoopData = $customRoles ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                    <span class="badge bg-<?php echo e($role->color ?? 'secondary'); ?>">
                                        <i class="bi bi-person-badge me-1"></i><?php echo e($role->name); ?>

                                    </span>
                                    </td>
                                    <td><?php echo e($role->description ?? 'Custom role'); ?></td>
                                    <td>
                                        <span class="badge bg-light text-dark"><?php echo e(count($role->permissions ?? [])); ?> permissions</span>
                                    </td>
                                    <td><?php echo e($role->members_count ?? 0); ?></td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editRoleModal<?php echo e($role->id); ?>">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteRoleModal<?php echo e($role->id); ?>">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center py-4 text-muted">
                                        <i class="bi bi-shield-check fs-3 d-block mb-2"></i>
                                        No custom roles created yet. Click "Create New Role" to get started.
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>













                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        function showCreateRoleForm() {
            document.getElementById('createRoleForm').style.display = 'block';
            document.getElementById('createRoleForm').scrollIntoView({ behavior: 'smooth' });
        }

        function hideCreateRoleForm() {
            document.getElementById('createRoleForm').style.display = 'none';
        }

        function toggleCustomPermissions() {
            const roleSelect = document.getElementById('roleSelect');
            const permissionsSection = document.getElementById('customPermissionsSection');

            if (roleSelect.value === 'staff') {
                // Show custom permissions for Staff role
                permissionsSection.style.display = 'block';
            } else {
                // Hide for Manager and Custom roles
                permissionsSection.style.display = 'none';
            }
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            toggleCustomPermissions();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/team/index.blade.php ENDPATH**/ ?>