<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="fw-bold mb-1">Welcome back, <?php echo e(auth()->user()->first_name); ?>!</h2>
            <p class="text-muted mb-0">Here's what's happening with your business today.</p>
        </div>
        <div>
            <button class="btn btn-outline-primary me-2">
                <i class="bi bi-download me-2"></i>Export Report
            </button>
            <button class="btn btn-primary">
                <i class="bi bi-plus-lg me-2"></i>New Offer
            </button>
        </div>
    </div>

    <!-- Verification Status Alert -->
    <?php if($business->status === 'pending'): ?>
        <div class="alert alert-warning border-0 shadow-sm mb-4">
            <div class="d-flex align-items-start">
                <i class="bi bi-hourglass-split fs-3 me-3"></i>
                <div class="flex-grow-1">
                    <h5 class="alert-heading mb-2"><strong>Verification Pending</strong></h5>
                    <p class="mb-0">Your business registration is under review. Our team will verify your documents and get back to you soon.</p>
                    <small class="text-muted d-block mt-1">Submitted: <?php echo e($business->created_at->format('M d, Y h:i A')); ?></small>
                </div>
            </div>
        </div>
    <?php elseif($business->status === 'rejected'): ?>
        <div class="alert alert-danger border-0 shadow-sm mb-4">
            <div class="d-flex align-items-start">
                <i class="bi bi-x-circle fs-3 me-3"></i>
                <div class="flex-grow-1">
                    <h5 class="alert-heading mb-2"><strong>Verification Rejected</strong></h5>
                    <p class="mb-2">Unfortunately, your business registration has been rejected. Please review the feedback below and resubmit your application.</p>

                    <?php if($business->verification_notes): ?>
                        <div class="border-top pt-3 mt-3">
                            <h6 class="fw-semibold mb-2"><i class="bi bi-clipboard-check me-2"></i>Admin Feedback:</h6>
                            <div class="bg-white p-3 rounded border">
                                <p class="mb-0"><?php echo e($business->verification_notes); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="mt-3">
                        <a href="<?php echo e(route('business.settings')); ?>" class="btn btn-danger btn-sm">
                            <i class="bi bi-pencil me-2"></i>Update Business Information
                        </a>
                        <a href="<?php echo e(route('business.support.create')); ?>" class="btn btn-outline-danger btn-sm ms-2">
                            <i class="bi bi-question-circle me-2"></i>Contact Support
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php elseif($business->status === 'verified'): ?>
        <div class="alert alert-success border-0 shadow-sm mb-4">
            <div class="d-flex align-items-start">
                <i class="bi bi-check-circle fs-3 me-3"></i>
                <div class="flex-grow-1">
                    <h5 class="alert-heading mb-2"><strong>Business Verified!</strong></h5>
                    <p class="mb-0">Congratulations! Your business has been verified and approved.</p>
                    <?php if($business->verification_notes): ?>
                        <small class="text-muted d-block mt-2">
                            <i class="bi bi-info-circle me-1"></i>Note: <?php echo e($business->verification_notes); ?>

                        </small>
                    <?php endif; ?>
                    <small class="text-muted d-block mt-1">Verified on: <?php echo e($business->verified_at ? $business->verified_at->format('M d, Y h:i A') : 'N/A'); ?></small>
                </div>
            </div>
        </div>
    <?php elseif($business->status === 'suspended'): ?>
        <div class="alert alert-warning border-0 shadow-sm mb-4">
            <div class="d-flex align-items-start">
                <i class="bi bi-pause-circle fs-3 me-3"></i>
                <div class="flex-grow-1">
                    <h5 class="alert-heading mb-2"><strong>Account Suspended</strong></h5>
                    <p class="mb-2">Your business account has been temporarily suspended.</p>

                    <?php if($business->verification_notes): ?>
                        <div class="border-top pt-3 mt-3">
                            <h6 class="fw-semibold mb-2"><i class="bi bi-clipboard-check me-2"></i>Reason:</h6>
                            <div class="bg-white p-3 rounded border">
                                <p class="mb-0"><?php echo e($business->verification_notes); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="mt-3">
                        <a href="<?php echo e(route('business.support.create')); ?>" class="btn btn-warning btn-sm">
                            <i class="bi bi-question-circle me-2"></i>Contact Support
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Stats Cards -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                    <i class="bi bi-geo-alt text-white"></i>
                </div>
                <div class="stat-label">Total Venues</div>
                <div class="stat-value"><?php echo e($stats['total_venues'] ?? 0); ?></div>
                <div class="stat-change positive">
                    <i class="bi bi-arrow-up"></i> 12% vs last month
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                    <i class="bi bi-tag text-white"></i>
                </div>
                <div class="stat-label">Active Offers</div>
                <div class="stat-value"><?php echo e($stats['active_offers'] ?? 0); ?></div>
                <div class="stat-change positive">
                    <i class="bi bi-arrow-up"></i> 8% vs last month
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                    <i class="bi bi-qr-code-scan text-white"></i>
                </div>
                <div class="stat-label">Total Redemptions</div>
                <div class="stat-value"><?php echo e($stats['total_redemptions'] ?? 0); ?></div>
                <div class="stat-change positive">
                    <i class="bi bi-arrow-up"></i> 23% vs last month
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                    <i class="bi bi-star text-white"></i>
                </div>
                <div class="stat-label">Average Rating</div>
                <div class="stat-value"><?php echo e(number_format($stats['average_rating'] ?? 0, 1)); ?></div>
                <div class="stat-change positive">
                    <i class="bi bi-arrow-up"></i> 0.3 vs last month
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mb-4">
        <!-- Performance Chart -->
        <div class="col-lg-8">
            <div class="table-card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 fw-bold">Performance Overview</h5>
                        <div class="btn-group btn-group-sm">
                            <button class="btn btn-outline-secondary active">7 Days</button>
                            <button class="btn btn-outline-secondary">30 Days</button>
                            <button class="btn btn-outline-secondary">90 Days</button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="performanceChart" height="80"></canvas>
                </div>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="col-lg-4">
            <div class="table-card h-100">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Quick Stats</h5>
                </div>
                <div class="card-body">
                    <div class="mb-4">
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Pending Approvals</span>
                            <span class="fw-bold"><?php echo e($stats['pending_approval'] ?? 0); ?></span>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-warning" style="width: 65%"></div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Redemption Rate</span>
                            <span class="fw-bold">78%</span>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-success" style="width: 78%"></div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Customer Engagement</span>
                            <span class="fw-bold">85%</span>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-info" style="width: 85%"></div>
                        </div>
                    </div>

                    <div>
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Offer Performance</span>
                            <span class="fw-bold">92%</span>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-primary" style="width: 92%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <!-- Recent Redemptions -->
        <div class="col-lg-8">
            <div class="table-card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0 fw-bold">Recent Redemptions</h5>
                        <a href="<?php echo e(route('business.redemptions')); ?>" class="btn btn-sm btn-outline-primary">View All</a>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                            <tr>
                                <th>Customer</th>
                                <th>Offer</th>
                                <th>Venue</th>
                                <th>Code</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $recentRedemptions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $redemption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <img src="https://ui-avatars.com/api/?name=<?php echo e($redemption->user->full_name); ?>"
                                                 class="rounded-circle" width="32" height="32">
                                            <span class="fw-medium"><?php echo e($redemption->user->full_name); ?></span>
                                        </div>
                                    </td>
                                    <td><?php echo e(Str::limit($redemption->offer->title, 30)); ?></td>
                                    <td><?php echo e($redemption->venue->name); ?></td>
                                    <td><code><?php echo e($redemption->redemption_code); ?></code></td>
                                    <td>
                                        <?php if($redemption->status === 'redeemed'): ?>
                                            <span class="badge bg-success">Redeemed</span>
                                        <?php elseif($redemption->status === 'pending'): ?>
                                            <span class="badge bg-warning">Pending</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary"><?php echo e(ucfirst($redemption->status)); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($redemption->created_at->diffForHumans()); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center py-4 text-muted">
                                        <i class="bi bi-inbox fs-1 d-block mb-2"></i>
                                        No redemptions yet
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Performing Offers -->
        <div class="col-lg-4">
            <div class="table-card h-100">
                <div class="card-header">
                    <h5 class="mb-0 fw-bold">Top Performing Offers</h5>
                </div>
                <div class="card-body">
                    <?php $__empty_1 = true; $__currentLoopData = $topOffers ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="mb-3 pb-3 border-bottom">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h6 class="mb-1 fw-semibold"><?php echo e(Str::limit($offer->title, 40)); ?></h6>
                                <span class="badge bg-primary"><?php echo e($offer->redemption_count); ?></span>
                            </div>
                            <div class="d-flex gap-3 small text-muted">
                                <span><i class="bi bi-eye me-1"></i><?php echo e($offer->view_count); ?> views</span>
                                <span><i class="bi bi-graph-up me-1"></i><?php echo e(number_format(($offer->redemption_count / max($offer->view_count, 1)) * 100, 1)); ?>%</span>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center py-4 text-muted">
                            <i class="bi bi-tag fs-1 d-block mb-2"></i>
                            <p class="mb-0">No offers yet</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        // Performance Chart
        const ctx = document.getElementById('performanceChart').getContext('2d');
        const performanceChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
                datasets: [
                    {
                        label: 'Redemptions',
                        data: [12, 19, 15, 25, 22, 30, 28],
                        borderColor: '#6366f1',
                        backgroundColor: 'rgba(99, 102, 241, 0.1)',
                        tension: 0.4,
                        fill: true
                    },
                    {
                        label: 'Views',
                        data: [45, 52, 48, 65, 58, 72, 68],
                        borderColor: '#8b5cf6',
                        backgroundColor: 'rgba(139, 92, 246, 0.1)',
                        tension: 0.4,
                        fill: true
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: '#f3f4f6'
                        }
                    },
                    x: {
                        grid: {
                            display: false
                        }
                    }
                }
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.business', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\privasee\resources\views/business/dashboard.blade.php ENDPATH**/ ?>