<?php

/**
 * Send notification to user with configured channels
 */
function notify($user, $type, $data, $channels = ['database'])
{
    return \App\Services\NotificationService::send($user, $type, $data, $channels);
}

/**
 * Get unread notifications count for user
 */
function unreadNotificationsCount($user)
{
    return \App\Services\NotificationService::getUnreadNotifications($user)->count();
}

/**
 * Get configuration value
 */
function config_value($key, $default = null)
{
    $config = \App\Models\SystemConfiguration::findByKey($key);
    return $config ? $config->value : $default;
}

/**
 * Set configuration value
 */
function set_config_value($key, $value)
{
    $config = \App\Models\SystemConfiguration::findByKey($key);

    if ($config) {
        $config->update(['value' => $value]);
    } else {
        \App\Models\SystemConfiguration::create(['key' => $key, 'value' => $value]);
    }

    return true;
}

