<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AdminActivityLog;
use Illuminate\Http\Request;

class ActivityController extends Controller
{
    /**
     * Display a listing of admin activities
     */
    public function index(Request $request)
    {
        $activities = AdminActivityLog::with('adminUser')
            ->latest()
            ->paginate(50);

        return view('admin.activities.index', compact('activities'));
    }

    /**
     * Display a specific activity
     */
    public function show($id)
    {
        $activity = AdminActivityLog::findOrFail($id);

        return view('admin.activities.show', compact('activity'));
    }

    /**
     * Delete a specific activity
     */
    public function destroy($id)
    {
        $activity = AdminActivityLog::findOrFail($id);
        $activity->delete();

        return redirect()->route('admin.activities.index')
            ->with('success', 'Activity deleted successfully.');
    }

    /**
     * Clear all activities
     */
    public function clear()
    {
        AdminActivityLog::truncate();

        return redirect()->route('admin.activities.index')
            ->with('success', 'All activities cleared successfully.');
    }
}

