<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class AdminPermissionMiddleware
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        if (!auth()->check()) {
            return redirect()->route('login');
        }

        $user = auth()->user();

        // Check if user is admin or has admin role
        if (!$this->isAdmin($user)) {
            abort(403, 'Unauthorized. Admin access required.');
        }

        // Store admin check in request
        $request->attributes->set('is_admin', true);

        return $next($request);
    }

    /**
     * Check if user is admin
     */
    protected function isAdmin($user)
    {
        return $user->hasAnyRole(['admin', 'super_admin']) ||
               $user->hasPermissionTo('admin.access');
    }
}

