<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class TeamAccessMiddleware
{
    /**
     * Handle an incoming request.
     *
     * Middleware to ensure user has access to the team they're trying to access.
     * Should be used with route parameters like: middleware('team.access:team')
     */
    public function handle(Request $request, Closure $next, string $param = 'team'): Response
    {
        $user = auth()->user();

        if (!$user) {
            return redirect()->route('login');
        }

        // Get team from route parameter
        $team = $request->route($param);

        if (!$team) {
            return $next($request);
        }

        // Check if user is member of team
        if (!$user->isMemberOfTeam($team)) {
            abort(403, 'Unauthorized: You do not have access to this team.');
        }

        // Store current team in request for easy access
        $request->attributes->set('current_team', $team);

        return $next($request);
    }
}

