<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    protected $fillable = [
        'parent_id',
        'name',
        'name_ar',
        'slug',
        'description',
        'description_ar',
        'icon',
        'image',
        'order',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function parent()
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    public function venues()
    {
        return $this->hasMany(Venue::class);
    }

    public function offers()
    {
        return $this->hasMany(Offer::class);
    }

    public function businesses()
    {
        return $this->hasManyThrough(Business::class, Venue::class, 'category_id', 'id', 'id', 'business_id');
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeParents($query)
    {
        return $query->whereNull('parent_id');
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('order');
    }

//    get active venues
    public function activeVenues()
    {
        return $this->venues()->where('status', 'active');
    }
//    get active offers
    public function activeOffers()
    {
        return $this->offers()->where('status', 'active')->where('approval_status', 'approved');
    }
}
