<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Redemption extends Model
{
    use HasFactory;

    protected $fillable = [
        'offer_id',
        'user_id',
        'venue_id',
        'redemption_code',
        'redeemed_at',
        'redeemed_by_staff',
        'status',
        'notes',
    ];

    protected $casts = [
        'redeemed_at' => 'datetime',
    ];

    public function offer()
    {
        return $this->belongsTo(Offer::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function venue()
    {
        return $this->belongsTo(Venue::class);
    }

    public function staff()
    {
        return $this->belongsTo(User::class, 'redeemed_by_staff');
    }

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    public function scopeRedeemed($query)
    {
        return $query->where('status', 'redeemed');
    }

    public function scopeExpired($query)
    {
        return $query->where('status', 'expired');
    }

    public function isRedeemed()
    {
        return $this->status === 'redeemed';
    }

    public function isPending()
    {
        return $this->status === 'pending';
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($redemption) {
            if (empty($redemption->redemption_code)) {
                $redemption->redemption_code = strtoupper(substr(md5(uniqid()), 0, 12));
            }
        });
    }
}
