<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Venue extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'business_id',
        'category_id',
        'name',
        'name_ar',
        'slug',
        'description',
        'description_ar',
        'address',
        'address_ar',
        'city',
        'area',
        'latitude',
        'longitude',
        'phone',
        'email',
        'website',
        'working_hours',
        'amenities',
        'images',
        'featured_image',
        'status',
        'is_featured',
        'view_count',
        'rating',
        'total_reviews',
        'redeem_code',
        'rejection_reason',
        'rejection_checklist',
        'verification_attempts',
    ];

    protected $casts = [
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8',
        'working_hours' => 'array',
        'amenities' => 'array',
        'images' => 'array',
        'is_featured' => 'boolean',
        'rating' => 'decimal:2',
        'rejection_checklist' => 'array',
    ];

    public function business()
    {
        return $this->belongsTo(Business::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function offers()
    {
        return $this->hasMany(Offer::class);
    }

    public function reviews()
    {
        return $this->hasMany(Review::class);
    }

    public function redemptions()
    {
        return $this->hasMany(Redemption::class);
    }

    public function favorites()
    {
        return $this->morphMany(Favorite::class, 'favorable');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($venue) {
            if (empty($venue->slug)) {
                $venue->slug = \Str::slug($venue->name) . '-' . uniqid();
            }
        });
    }
}
