<?php

namespace App\Policies;

use App\Models\Chat;
use App\Models\User;

class ChatPolicy
{
    /**
     * Determine whether the user can view the chat.
     */
    public function view(User $user, Chat $chat): bool
    {
        return $chat->hasParticipant($user) || $user->isAdminUser();
    }

    /**
     * Determine whether the user can create a model.
     */
    public function create(User $user): bool
    {
        return true; // Users can create chats
    }

    /**
     * Determine whether the user can post messages.
     */
    public function postMessage(User $user, Chat $chat): bool
    {
        return $chat->hasParticipant($user);
    }

    /**
     * Determine whether the user can delete a message.
     */
    public function deleteMessage(User $user, Chat $chat): bool
    {
        $participant = $chat->participants()->where('user_id', $user->id)->first();

        return $participant && in_array($participant->pivot->role, ['admin', 'member']);
    }

    /**
     * Determine whether the user can manage chat participants.
     */
    public function manageParticipants(User $user, Chat $chat): bool
    {
        $participant = $chat->participants()->where('user_id', $user->id)->first();

        return $participant && $participant->pivot->role === 'admin';
    }
}

