<?php

namespace App\Policies;

use App\Models\Team;
use App\Models\User;

class TeamPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->isMemberOfTeam(new Team()) || $user->isAdminUser();
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Team $team): bool
    {
        return $user->isMemberOfTeam($team) || $user->isAdminUser();
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->isAdminUser() || $user->hasPermissionTo('teams.create');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Team $team): bool
    {
        if ($user->isAdminUser()) {
            return true;
        }

        return $user->isMemberOfTeam($team) && $team->isAdmin($user);
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Team $team): bool
    {
        if ($user->isAdminUser()) {
            return true;
        }

        return $team->business->owner_id === $user->id;
    }

    /**
     * Determine if user can manage team members
     */
    public function manageMembers(User $user, Team $team): bool
    {
        return $this->update($user, $team);
    }
}

