<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Load helper functions
        $this->loadHelpers();

        // Register Blade directives
        $this->app->register(BladeServiceProvider::class);

        // Register Permission gates
        $this->app->register(PermissionServiceProvider::class);
    }

    /**
     * Load helper files
     */
    private function loadHelpers(): void
    {
        $helpers = [
            'NotificationHelper',
        ];

        foreach ($helpers as $helper) {
            $path = app_path("Helpers/{$helper}.php");
            if (file_exists($path)) {
                require_once $path;
            }
        }
    }
}
