<?php

namespace App\Providers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;

class BladeServiceProvider extends ServiceProvider
{
    public function register()
    {
        //
    }

    public function boot()
    {
        // @role directive - Check if user has a specific role
        Blade::if('role', function ($role, $businessId = null) {
            if (!auth()->check()) {
                return false;
            }
            return auth()->user()->hasRole($role, $businessId);
        });

        // @hasanyrole directive - Check if user has any of the given roles
        Blade::if('hasanyrole', function ($roles, $businessId = null) {
            if (!auth()->check()) {
                return false;
            }

            if (is_string($roles)) {
                $roles = explode('|', $roles);
            }

            return auth()->user()->hasAnyRole($roles, $businessId);
        });

        // @hasallroles directive - Check if user has all given roles
        Blade::if('hasallroles', function ($roles, $businessId = null) {
            if (!auth()->check()) {
                return false;
            }

            if (is_string($roles)) {
                $roles = explode('|', $roles);
            }

            foreach ($roles as $role) {
                if (!auth()->user()->hasRole($role, $businessId)) {
                    return false;
                }
            }

            return true;
        });

        // @haspermission directive - Check if user has a specific permission
        Blade::if('haspermission', function ($permission, $businessId = null) {
            if (!auth()->check()) {
                return false;
            }
            return auth()->user()->hasPermission($permission, $businessId);
        });

        // @hasanypermission directive - Check if user has any of the given permissions
        Blade::if('hasanypermission', function ($permissions, $businessId = null) {
            if (!auth()->check()) {
                return false;
            }

            if (is_string($permissions)) {
                $permissions = explode('|', $permissions);
            }

            return auth()->user()->hasAnyPermission($permissions, $businessId);
        });

        // @hasallpermissions directive - Check if user has all given permissions
        Blade::if('hasallpermissions', function ($permissions, $businessId = null) {
            if (!auth()->check()) {
                return false;
            }

            if (is_string($permissions)) {
                $permissions = explode('|', $permissions);
            }

            foreach ($permissions as $permission) {
                if (!auth()->user()->hasPermission($permission, $businessId)) {
                    return false;
                }
            }

            return true;
        });

        // @issuperadmin directive
        Blade::if('issuperadmin', function () {
            if (!auth()->check()) {
                return false;
            }
            return auth()->user()->hasRole('super_admin');
        });

        // @isadmin directive
        Blade::if('isadmin', function () {
            if (!auth()->check()) {
                return false;
            }
            return auth()->user()->hasAnyRole(['super_admin', 'admin']);
        });

        // @isbusinessowner directive
        Blade::if('isbusinessowner', function ($businessId = null) {
            if (!auth()->check()) {
                return false;
            }

            $user = auth()->user();

            if ($businessId) {
                return $user->businesses()->where('id', $businessId)->exists();
            }

            return $user->businesses()->exists();
        });
    }
}
