<?php

namespace App\Traits;

use App\Models\Business;

trait GetUserBusiness
{
    /**
     * Get the business for the current user
     * Handles both business owners and staff members
     *
     * @return Business|null
     */
    protected function getUserBusiness()
    {
        $user = auth()->user();

        // Check if user is a staff member
        if ($user->hasRole('business_manager') || $user->account_type === 'user') {
            return $user->getOwnerBusinessForStaff();
        }

        // Otherwise, get their own business
        return $user->business;
    }

    /**
     * Get all business IDs for the current user
     * Handles both owner (single business) and staff (could be part of multiple businesses)
     *
     * @return array
     */
    protected function getUserBusinessIds()
    {
        $user = auth()->user();

        // If staff member, get business through staff relationship
        if ($user->hasRole('business_manager') || $user->account_type === 'user') {
            $business = $user->getOwnerBusinessForStaff();
            return $business ? [$business->id] : [];
        }

        // If owner, get their businesses
        return $user->businesses()->pluck('id')->toArray();
    }
}

