<?php

/**
 * Admin Configuration Settings
 *
 * Configuration for the enhanced admin panel system including security,
 * audit trails, and session management.
 */

return [
    // Session configuration
    'sessions' => [
        'timeout_minutes' => env('ADMIN_SESSION_TIMEOUT', 30),
        'max_sessions_per_user' => env('ADMIN_MAX_SESSIONS', 5),
        'track_activity' => true,
        'cleanup_days' => 90,
    ],

    // Activity logging
    'activity_logging' => [
        'enabled' => true,
        'log_sensitive_only' => false,
        'log_read_operations' => false,
        'sensitive_fields' => [
            'password',
            'secret_key',
            'api_key',
            'token',
        ],
        'retention_days' => 365,
    ],

    // Security settings
    'security' => [
        'enforce_ip_restrictions' => false,
        'rate_limit_enabled' => true,
        'rate_limit_per_minute' => 100,
        'suspicious_activity_detection' => true,
        'require_mfa_for_super_admin' => false,
        'require_mfa_for_admin' => false,
    ],

    // IP Restriction settings
    'ip_restrictions' => [
        'enabled' => false,
        'default_action' => 'allow', // allow or deny
        'check_on_every_request' => true,
    ],

    // Configuration versioning
    'versioning' => [
        'auto_snapshot' => false,
        'snapshot_on_critical_change' => true,
        'keep_versions' => 50,
        'auto_cleanup_versions' => true,
    ],

    // Bulk operations
    'bulk_operations' => [
        'batch_size' => 100,
        'timeout_seconds' => 300,
        'log_enabled' => true,
    ],

    // Audit trail
    'audit' => [
        'track_logins' => true,
        'track_configuration_changes' => true,
        'track_user_changes' => true,
        'track_role_changes' => true,
        'track_permission_changes' => true,
        'mark_sensitive_operations' => true,
    ],

    // MFA settings
    'mfa' => [
        'enabled' => false,
        'methods' => ['email', 'authenticator', 'sms'],
        'backup_codes_count' => 10,
        'max_attempts' => 5,
        'lockout_minutes' => 30,
    ],

    // Roles hierarchy
    'roles' => [
        'hierarchy_enabled' => true,
        'allow_custom_roles' => true,
        'system_roles_editable' => false,
    ],

    // Feature flags
    'features' => [
        'configuration_versioning' => true,
        'activity_auditing' => true,
        'session_management' => true,
        'ip_restrictions' => true,
        'bulk_operations' => true,
        'mfa' => false, // Coming in Phase 2
        'approval_workflows' => false, // Coming in Phase 3
        'system_health_monitoring' => false, // Coming in Phase 4
    ],

    // Notifications
    'notifications' => [
        'notify_on_failed_login' => true,
        'notify_on_suspicious_activity' => true,
        'notify_on_configuration_change' => true,
        'notify_on_bulk_operation' => true,
        'notification_channel' => 'email', // email, slack, database
    ],

    // Performance tuning
    'performance' => [
        'cache_ip_restrictions' => true,
        'cache_duration_minutes' => 5,
        'enable_query_caching' => true,
        'batch_cleanup_size' => 1000,
    ],

    // Email templates
    'email_templates' => [
        'activity_alerts_enabled' => true,
        'configuration_change_template' => 'emails.admin.configuration-changed',
        'suspicious_activity_template' => 'emails.admin.suspicious-activity',
        'session_terminated_template' => 'emails.admin.session-terminated',
    ],

    // Super admin settings
    'super_admin' => [
        'can_edit_system_roles' => true,
        'can_restore_backups' => true,
        'can_purge_logs' => true,
        'can_modify_security_settings' => true,
        'can_access_all_data' => true,
    ],

    // Admin panel settings
    'panel' => [
        'items_per_page' => 25,
        'max_export_records' => 10000,
        'enable_dark_mode' => true,
        'enable_sidebar_toggle' => true,
        'default_theme' => 'light', // light or dark
    ],

    // Dashboard
    'dashboard' => [
        'show_statistics' => true,
        'show_recent_activities' => true,
        'show_system_health' => true,
        'refresh_interval_seconds' => 30,
    ],

    // Menu configuration
    'menu' => [
        'show_badges' => true,
        'collapse_menu_on_mobile' => true,
        'show_icons' => true,
        'menu_width' => 250, // pixels
    ],
];

