<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email')->unique();
            $table->string('phone')->unique()->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->timestamp('phone_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->enum('gender', ['female', 'male', 'other'])->default('female');
            $table->date('date_of_birth')->nullable();
            $table->string('profile_image')->nullable();
            $table->enum('account_type', ['user', 'business', 'admin'])->default('user');
            $table->enum('status', ['active', 'inactive', 'suspended', 'pending_verification'])->default('active');
            $table->string('language', 5)->default('en');
            $table->boolean('dark_mode')->default(false);
            $table->json('interests')->nullable();
            $table->json('preferences')->nullable();
            $table->string('referral_code', 20)->unique()->nullable();
            $table->foreignId('referred_by')->nullable()->constrained('users')->onDelete('set null');
            $table->boolean('biometric_enabled')->default(false);
            $table->string('device_token')->nullable();
            $table->string('fcm_token')->nullable();
            $table->timestamp('last_active_at')->nullable();
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();

            $table->index('email');
            $table->index('phone');
            $table->index('referral_code');
            $table->index('status');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
